/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;

public class ArtifactBuildTargetScopeProvider
extends BuildTargetScopeProvider {
    @Override
    @NotNull
    public List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildTargetScopes(final @NotNull CompileScope baseScope, @NotNull CompilerFilter filter, final @NotNull Project project2, final boolean forceBuild) {
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "com/intellij/packaging/impl/compiler/ArtifactBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/packaging/impl/compiler/ArtifactBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/compiler/ArtifactBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        ArtifactsCompiler compiler = ArtifactsCompiler.getInstance(project2);
        if (compiler == null || !filter.acceptCompiler((Compiler)compiler)) {
            List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactBuildTargetScopeProvider", "getBuildTargetScopes"));
            }
            return list;
        }
        final ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        new ReadAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/packaging/impl/compiler/ArtifactBuildTargetScopeProvider$1", "run"));
                }
                Set<Artifact> artifacts = ArtifactCompileScope.getArtifactsToBuild(project2, baseScope, false);
                if (ArtifactCompileScope.getArtifacts(baseScope) == null) {
                    Set<Module> modules = ArtifactUtil.getModulesIncludedInArtifacts(artifacts, project2);
                    CompileScopeUtil.addScopesForModules(modules, scopes, forceBuild);
                }
                if (!artifacts.isEmpty()) {
                    CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(ArtifactBuildTargetType.INSTANCE.getTypeId()).setForceBuild(ArtifactCompileScope.isArtifactRebuildForced(baseScope));
                    for (Artifact artifact : artifacts) {
                        builder.addTargetId(artifact.getName());
                    }
                    scopes.add(builder.build());
                }
            }
        }.execute();
        ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> arrayList = scopes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        return arrayList;
    }
}

