/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.AuxiliaryRightPanel;
import com.intellij.profile.codeInspection.ui.header.ManageButton;
import com.intellij.profile.codeInspection.ui.header.ManageButtonBuilder;
import com.intellij.profile.codeInspection.ui.header.ProfilesConfigurableComboBox;
import com.intellij.profile.codeInspection.ui.header.SaveInputComponentValidator;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionToolsConfigurable
extends BaseConfigurable
implements ErrorsConfigurable,
SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "Errors";
    public static final String DISPLAY_NAME = "Inspections";
    private static final String HEADER_TITLE = "Profile:";
    private static final Logger LOG = Logger.getInstance(InspectionToolsConfigurable.class);
    protected final InspectionProfileManager myApplicationProfileManager;
    protected final InspectionProjectProfileManager myProjectProfileManager;
    private final CardLayout myLayout;
    private final Map<Profile, SingleInspectionProfilePanel> myPanels;
    private final List<Profile> myDeletedProfiles;
    protected ProfilesConfigurableComboBox myProfiles;
    private JPanel myPanel;
    private AuxiliaryRightPanel myAuxiliaryRightPanel;
    private Alarm mySelectionAlarm;

    public InspectionToolsConfigurable(@NotNull InspectionProjectProfileManager projectProfileManager, InspectionProfileManager profileManager) {
        if (projectProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectProfileManager", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "<init>"));
        }
        this.myLayout = new CardLayout();
        this.myPanels = new HashMap();
        this.myDeletedProfiles = new ArrayList<Profile>();
        this.myProjectProfileManager = projectProfileManager;
        this.myApplicationProfileManager = profileManager;
    }

    private static JComponent withBorderOnTop(JComponent component) {
        JPanel panel = new JPanel();
        panel.add(component);
        panel.setBorder(IdeBorderFactory.createEmptyBorder((int)(UIUtil.isUnderDarcula() ? 10 : 13), (int)0, (int)0, (int)0));
        return panel;
    }

    private Project getProject() {
        return this.myProjectProfileManager.getProject();
    }

    @Nullable
    private InspectionProfileImpl copyToNewProfile(ModifiableModel selectedProfile, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "copyToNewProfile"));
        }
        String profileDefaultName = selectedProfile.getName();
        while (this.hasName(profileDefaultName = profileDefaultName + " (copy)", this.myPanels.get(selectedProfile).isProjectLevel())) {
        }
        ProfileManager profileManager = selectedProfile.getProfileManager();
        InspectionProfileImpl inspectionProfile = new InspectionProfileImpl(profileDefaultName, InspectionToolRegistrar.getInstance(), profileManager);
        inspectionProfile.copyFrom((Profile)selectedProfile);
        inspectionProfile.setName(profileDefaultName);
        inspectionProfile.initInspectionTools(project2);
        inspectionProfile.setModified(true);
        return inspectionProfile;
    }

    private void addProfile(InspectionProfileImpl model, InspectionProfileImpl profile) {
        String modelName = model.getName();
        SingleInspectionProfilePanel panel = this.createPanel(model, profile, modelName);
        this.myPanel.add(InspectionToolsConfigurable.getCardName(model), panel);
        this.myProfiles.getModel().addElement(model);
        this.putProfile(model, panel);
        this.myProfiles.selectProfile(model);
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return "preferences.inspections";
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "getId"));
        }
        return ID;
    }

    public Runnable enableSearch(final String option) {
        return new Runnable(){

            @Override
            public void run() {
                SingleInspectionProfilePanel panel = InspectionToolsConfigurable.this.getSelectedPanel();
                if (panel != null) {
                    panel.setFilter(option);
                }
            }
        };
    }

    public JComponent createComponent() {
        final JPanel wholePanel = new JPanel();
        wholePanel.setLayout(new BorderLayout());
        JPanel toolbar = new JPanel();
        toolbar.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 0));
        this.myPanel = new JPanel();
        wholePanel.add((Component)toolbar, "First");
        wholePanel.add((Component)this.myPanel, "Center");
        this.myAuxiliaryRightPanel = new AuxiliaryRightPanel(new AuxiliaryRightPanel.DescriptionSaveListener(){

            @Override
            public void saveDescription(@NotNull String description) {
                if (description == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable$2", "saveDescription"));
                }
                InspectionProfileImpl inspectionProfile = InspectionToolsConfigurable.this.getSelectedObject();
                if (!Comparing.strEqual((String)description, (String)inspectionProfile.getDescription())) {
                    inspectionProfile.setDescription(description);
                    inspectionProfile.setModified(true);
                }
                InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showDescription(description);
            }

            @Override
            public void cancel() {
                InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showDescription(InspectionToolsConfigurable.this.getSelectedObject().getDescription());
            }
        });
        this.myProfiles = new ProfilesConfigurableComboBox((ListCellRendererWrapper)new ListCellRendererWrapper<Profile>(){

            public void customize(JList list, Profile value, int index, boolean selected, boolean hasFocus) {
                SingleInspectionProfilePanel singleInspectionProfilePanel = InspectionToolsConfigurable.this.getProfilePanel(value);
                if (singleInspectionProfilePanel != null) {
                    boolean isShared = singleInspectionProfilePanel.isProjectLevel();
                    this.setIcon(isShared ? AllIcons.General.ProjectSettings : AllIcons.General.Settings);
                    this.setText(singleInspectionProfilePanel.getCurrentProfileName());
                }
            }
        }){

            @Override
            public void onProfileChosen(InspectionProfileImpl inspectionProfile) {
                InspectionToolsConfigurable.this.myLayout.show(InspectionToolsConfigurable.this.myPanel, InspectionToolsConfigurable.getCardName(inspectionProfile));
                InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showDescription(inspectionProfile.getDescription());
            }
        };
        JPanel profilesHolder = new JPanel();
        profilesHolder.setLayout(new CardLayout());
        JComponent manageButton = new ManageButton(new ManageButtonBuilder(){

            @Override
            public boolean isProjectLevel() {
                SingleInspectionProfilePanel panel = InspectionToolsConfigurable.this.getSelectedPanel();
                return panel != null && panel.isProjectLevel();
            }

            @Override
            public void setIsProjectLevel(boolean isProjectLevel) {
                SingleInspectionProfilePanel selectedPanel = InspectionToolsConfigurable.this.getSelectedPanel();
                LOG.assertTrue(selectedPanel != null, (Object)("No settings selectedPanel for: " + InspectionToolsConfigurable.this.getSelectedObject()));
                String name = InspectionToolsConfigurable.this.getSelectedPanel().getCurrentProfileName();
                for (SingleInspectionProfilePanel p : InspectionToolsConfigurable.this.myPanels.values()) {
                    boolean curShared;
                    if (p == selectedPanel || !Comparing.equal((String)p.getCurrentProfileName(), (String)name) || (curShared = p.isProjectLevel()) != isProjectLevel) continue;
                    Messages.showErrorDialog((String)((isProjectLevel ? "Shared" : "Application level") + " profile with same name exists."), (String)"Inspections Settings");
                    return;
                }
                selectedPanel.setIsProjectLevel(isProjectLevel);
                InspectionToolsConfigurable.this.myProfiles.repaint();
            }

            @Override
            public void copy() {
                InspectionProfileImpl newProfile = InspectionToolsConfigurable.this.copyToNewProfile(InspectionToolsConfigurable.this.getSelectedObject(), InspectionToolsConfigurable.this.getProject());
                if (newProfile != null) {
                    InspectionProfileImpl modifiableModel = (InspectionProfileImpl)newProfile.getModifiableModel();
                    modifiableModel.setModified(true);
                    modifiableModel.setProjectLevel(false);
                    InspectionToolsConfigurable.this.addProfile(modifiableModel, newProfile);
                    this.rename(modifiableModel);
                }
            }

            @Override
            public boolean canRename() {
                InspectionProfileImpl profile = InspectionToolsConfigurable.this.getSelectedObject();
                return !profile.isProfileLocked();
            }

            @Override
            public void rename() {
                this.rename(InspectionToolsConfigurable.this.getSelectedObject());
            }

            private void rename(final @NotNull InspectionProfileImpl inspectionProfile) {
                if (inspectionProfile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable$5", "rename"));
                }
                final String initialName = InspectionToolsConfigurable.this.getSelectedPanel().getCurrentProfileName();
                InspectionToolsConfigurable.this.myProfiles.showEditCard(initialName, new SaveInputComponentValidator(){

                    @Override
                    public void doSave(@NotNull String text) {
                        if (text == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable$5$1", "doSave"));
                        }
                        if (!text.equals(initialName)) {
                            InspectionToolsConfigurable.this.getProfilePanel(inspectionProfile).setCurrentProfileName(text);
                        }
                        InspectionToolsConfigurable.this.myProfiles.showComboBoxCard();
                    }

                    @Override
                    public boolean checkValid(@NotNull String text) {
                        boolean isValid;
                        if (text == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable$5$1", "checkValid"));
                        }
                        SingleInspectionProfilePanel singleInspectionProfilePanel = (SingleInspectionProfilePanel)InspectionToolsConfigurable.this.myPanels.get(inspectionProfile);
                        if (singleInspectionProfilePanel == null) {
                            return false;
                        }
                        boolean bl = isValid = text.equals(initialName) || !InspectionToolsConfigurable.this.hasName(text, singleInspectionProfilePanel.isProjectLevel());
                        if (isValid) {
                            InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showDescription(InspectionToolsConfigurable.this.getSelectedObject().getDescription());
                        } else {
                            InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showError("Name is already in use. Please change name to unique.");
                        }
                        return isValid;
                    }

                    @Override
                    public void cancel() {
                        InspectionToolsConfigurable.this.myProfiles.showComboBoxCard();
                        InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showDescription(InspectionToolsConfigurable.this.getSelectedObject().getDescription());
                    }
                });
            }

            @Override
            public boolean canDelete() {
                return InspectionToolsConfigurable.this.isDeleteEnabled(InspectionToolsConfigurable.this.myProfiles.getSelectedProfile());
            }

            @Override
            public void delete() {
                InspectionProfileImpl selectedProfile = InspectionToolsConfigurable.this.myProfiles.getSelectedProfile();
                InspectionToolsConfigurable.this.myProfiles.getModel().removeElement(selectedProfile);
                InspectionToolsConfigurable.this.myDeletedProfiles.add(selectedProfile);
            }

            @Override
            public boolean canEditDescription() {
                return true;
            }

            @Override
            public void editDescription() {
                InspectionToolsConfigurable.this.myAuxiliaryRightPanel.editDescription(InspectionToolsConfigurable.this.getSelectedObject().getDescription());
            }

            @Override
            public boolean hasDescription() {
                return !StringUtil.isEmpty((String)InspectionToolsConfigurable.this.getSelectedObject().getDescription());
            }

            @Override
            public void export() {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                descriptor.setDescription("Choose directory to store profile file");
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)InspectionToolsConfigurable.this.getProject(), (Component)wholePanel, null, (Consumer)new Consumer<VirtualFile>(){

                    public void consume(VirtualFile file2) {
                        Element element = new Element("inspections");
                        try {
                            SingleInspectionProfilePanel panel = InspectionToolsConfigurable.this.getSelectedPanel();
                            LOG.assertTrue(panel != null);
                            InspectionProfileImpl profile = InspectionToolsConfigurable.this.getSelectedObject();
                            LOG.assertTrue(true);
                            profile.writeExternal(element);
                            String filePath = FileUtil.toSystemDependentName((String)file2.getPath()) + File.separator + FileUtil.sanitizeFileName((String)profile.getName()) + ".xml";
                            if (new File(filePath).isFile() && Messages.showOkCancelDialog((Component)wholePanel, (String)("File '" + filePath + "' already exist. Do you want to overwrite it?"), (String)"Warning", (Icon)Messages.getQuestionIcon()) != 0) {
                                return;
                            }
                            JDOMUtil.writeDocument((Document)new Document(element), (String)filePath, (String)SystemProperties.getLineSeparator());
                        }
                        catch (IOException e1) {
                            LOG.error((Throwable)e1);
                        }
                    }
                });
            }

            @Override
            public void doImport() {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file2) {
                        return file2.getFileType().equals(StdFileTypes.XML);
                    }
                };
                descriptor.setDescription("Choose profile file");
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)InspectionToolsConfigurable.this.getProject(), (Component)wholePanel, null, (Consumer)new Consumer<VirtualFile>(){

                    public void consume(VirtualFile file2) {
                        if (file2 != null) {
                            try {
                                Element rootElement = JDOMUtil.loadDocument((File)VfsUtilCore.virtualToIoFile((VirtualFile)file2)).getRootElement();
                                InspectionProfileImpl profile = InspectionToolsConfigurable.importInspectionProfile(rootElement, InspectionToolsConfigurable.this.myApplicationProfileManager, InspectionToolsConfigurable.this.getProject(), wholePanel);
                                if (InspectionToolsConfigurable.this.getProfilePanel(profile) != null && Messages.showOkCancelDialog((Component)wholePanel, (String)("Profile with name '" + profile.getName() + "' already exists. Do you want to overwrite it?"), (String)"Warning", (Icon)Messages.getInformationIcon()) != 0) {
                                    return;
                                }
                                ModifiableModel model = profile.getModifiableModel();
                                model.setModified(true);
                                InspectionToolsConfigurable.this.addProfile((InspectionProfileImpl)model, profile);
                                InspectionToolsConfigurable.this.myDeletedProfiles.remove(profile);
                            }
                            catch (JDOMException e) {
                                LOG.error((Throwable)e);
                            }
                            catch (IOException e) {
                                LOG.error((Throwable)e);
                            }
                            catch (InvalidDataException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                });
            }
        }).build();
        toolbar.setLayout(new GridBagLayout());
        JLabel headerTitleLabel = new JLabel(HEADER_TITLE);
        headerTitleLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
        toolbar.add((Component)headerTitleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add((Component)this.myProfiles, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 6, 0, 0), 0, 0));
        toolbar.add((Component)InspectionToolsConfigurable.withBorderOnTop(manageButton), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 10, 0, 0), 0, 0));
        toolbar.add((Component)this.myAuxiliaryRightPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 15, 0, 0), 0, 0));
        this.myPanel.setLayout(this.myLayout);
        return wholePanel;
    }

    public static InspectionProfileImpl importInspectionProfile(@NotNull Element rootElement, @NotNull InspectionProfileManager profileManager, @NotNull Project project2, @Nullable JPanel anchorPanel) throws JDOMException, IOException, InvalidDataException {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "importInspectionProfile"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "importInspectionProfile"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "importInspectionProfile"));
        }
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!unitTestMode) {
            LOG.assertTrue(anchorPanel != null);
        }
        InspectionProfileImpl profile = new InspectionProfileImpl("TempProfile", InspectionToolRegistrar.getInstance(), (ProfileManager)profileManager);
        if (Comparing.strEqual((String)rootElement.getName(), (String)"component")) {
            rootElement = (Element)rootElement.getChildren().get(0);
        }
        HashSet<String> levels = new HashSet<String>();
        for (Object o : rootElement.getChildren("inspection_tool")) {
            Element inspectElement = (Element)o;
            InspectionToolsConfigurable.addLevelIfNotNull(levels, inspectElement);
            for (Object s : inspectElement.getChildren("scope")) {
                InspectionToolsConfigurable.addLevelIfNotNull(levels, (Element)s);
            }
        }
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            String level = (String)iterator.next();
            if (profileManager.getOwnSeverityRegistrar().getSeverity(level) == null) continue;
            iterator.remove();
        }
        if (!levels.isEmpty()) {
            if (!unitTestMode) {
                if (Messages.showYesNoDialog((Component)anchorPanel, (String)("Undefined severities detected: " + StringUtil.join(levels, (String)", ") + ". Do you want to create them?"), (String)"Warning", (Icon)Messages.getWarningIcon()) == 0) {
                    for (String level : levels) {
                        TextAttributes textAttributes = CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes();
                        HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(new HighlightSeverity(level, 50), TextAttributesKey.createTextAttributesKey((String)level));
                        profileManager.getOwnSeverityRegistrar().registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
                    }
                }
            } else {
                throw new AssertionError((Object)("All of levels must exist in unit-test mode, but actual not exist levels = " + levels));
            }
        }
        profile.readExternal(rootElement);
        profile.setProjectLevel(false);
        profile.initInspectionTools(project2);
        return profile;
    }

    private static void addLevelIfNotNull(Set<String> levels, Element inspectElement) {
        String level = inspectElement.getAttributeValue("level");
        if (level != null) {
            levels.add(level);
        }
    }

    protected abstract InspectionProfileImpl getCurrentProfile();

    public boolean isModified() {
        InspectionProfileImpl currentProfile;
        InspectionProfileImpl selectedProfile = this.getSelectedObject();
        if (!Comparing.equal((Object)selectedProfile, (Object)(currentProfile = this.getCurrentProfile()))) {
            return true;
        }
        for (SingleInspectionProfilePanel panel : this.myPanels.values()) {
            if (!panel.isModified()) continue;
            return true;
        }
        if (this.getProfiles().size() != this.myPanels.size()) {
            return true;
        }
        return !this.myDeletedProfiles.isEmpty();
    }

    public void apply() throws ConfigurationException {
        SingleInspectionProfilePanel selectedPanel = this.getSelectedPanel();
        for (Profile inspectionProfile : this.myPanels.keySet()) {
            if (this.myDeletedProfiles.remove(inspectionProfile)) {
                this.deleteProfile((Profile)this.getProfilePanel(inspectionProfile).getSelectedProfile());
                continue;
            }
            SingleInspectionProfilePanel panel = this.getProfilePanel(inspectionProfile);
            panel.apply();
            if (panel != selectedPanel) continue;
            this.applyRootProfile(panel.getCurrentProfileName(), panel.isProjectLevel());
        }
        this.doReset();
    }

    protected abstract void applyRootProfile(@NotNull String var1, boolean var2);

    private SingleInspectionProfilePanel getProfilePanel(Profile inspectionProfile) {
        return this.myPanels.get(inspectionProfile);
    }

    private void putProfile(Profile profile, SingleInspectionProfilePanel panel) {
        this.myPanels.put(profile, panel);
    }

    private void deleteProfile(Profile profile) {
        String name = profile.getName();
        if (profile.getProfileManager() == this.myApplicationProfileManager) {
            if (this.myApplicationProfileManager.getProfile(name, false) != null) {
                this.myApplicationProfileManager.deleteProfile(name);
            }
            return;
        }
        if (profile.getProfileManager() == this.myProjectProfileManager && this.myProjectProfileManager.getProfile(name, false) != null) {
            this.myProjectProfileManager.deleteProfile(name);
        }
    }

    protected boolean acceptTool(InspectionToolWrapper entry) {
        return true;
    }

    public void reset() {
        this.doReset();
    }

    private void doReset() {
        this.myDeletedProfiles.clear();
        this.disposeUIResources();
        Collection<Profile> profiles = this.getProfiles();
        ArrayList<Profile> modifiableProfiles = new ArrayList<Profile>(profiles.size());
        for (Profile profile : profiles) {
            String profileName = profile.getName();
            ModifiableModel modifiableProfile = ((InspectionProfileImpl)profile).getModifiableModel();
            modifiableProfiles.add((Profile)modifiableProfile);
            InspectionProfileImpl inspectionProfile = (InspectionProfileImpl)modifiableProfile;
            SingleInspectionProfilePanel panel = this.createPanel(inspectionProfile, profile, profileName);
            this.putProfile((Profile)modifiableProfile, panel);
            this.myPanel.add(InspectionToolsConfigurable.getCardName(inspectionProfile), panel);
        }
        this.myProfiles.reset(modifiableProfiles);
        this.myAuxiliaryRightPanel.showDescription(this.getSelectedObject().getDescription());
        InspectionProfileImpl inspectionProfile = this.getCurrentProfile();
        this.myProfiles.selectProfile(inspectionProfile);
        this.myLayout.show(this.myPanel, InspectionToolsConfigurable.getCardName(inspectionProfile));
        final SingleInspectionProfilePanel panel = this.getSelectedPanel();
        if (panel != null) {
            panel.setVisible(true);
            this.mySelectionAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            this.mySelectionAlarm.cancelAllRequests();
            this.mySelectionAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    panel.updateSelection();
                }
            }, 200);
        }
    }

    private static String getCardName(InspectionProfileImpl inspectionProfile) {
        return (inspectionProfile.isProjectLevel() ? "s" : "a") + inspectionProfile.getName();
    }

    private SingleInspectionProfilePanel createPanel(InspectionProfileImpl profile, Profile original, String profileName) {
        return new SingleInspectionProfilePanel(this.myProjectProfileManager, profileName, profile, original){

            @Override
            protected boolean accept(InspectionToolWrapper entry) {
                return super.accept(entry) && InspectionToolsConfigurable.this.acceptTool(entry);
            }
        };
    }

    private boolean isDeleteEnabled(@NotNull InspectionProfileImpl inspectionProfile) {
        boolean isProjectProfile;
        Profile profile;
        if (inspectionProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "isDeleteEnabled"));
        }
        ProfileManager profileManager = inspectionProfile.getProfileManager();
        boolean projectProfileFound = false;
        boolean ideProfileFound = false;
        DefaultComboBoxModel model = this.myProfiles.getModel();
        for (int i = 0; !(i >= model.getSize() || inspectionProfile != (profile = (Profile)model.getElementAt(i)) && (ideProfileFound |= !(isProjectProfile = profile.getProfileManager() == this.myProjectProfileManager)) && (projectProfileFound |= isProjectProfile)); ++i) {
        }
        return profileManager == this.myProjectProfileManager ? projectProfileFound : ideProfileFound;
    }

    protected Collection<Profile> getProfiles() {
        ArrayList<Profile> result = new ArrayList<Profile>();
        result.addAll(new TreeSet(this.myApplicationProfileManager.getProfiles()));
        result.addAll(this.myProjectProfileManager.getProfiles());
        return result;
    }

    public void disposeUIResources() {
        for (SingleInspectionProfilePanel panel : this.myPanels.values()) {
            panel.disposeUI();
        }
        this.myPanels.clear();
        if (this.mySelectionAlarm != null) {
            Disposer.dispose((Disposable)this.mySelectionAlarm);
            this.mySelectionAlarm = null;
        }
    }

    @Override
    public void selectProfile(Profile profile) {
        this.myProfiles.selectProfile(profile);
    }

    @Override
    public void selectInspectionTool(String selectedToolShortName) {
        InspectionProfileImpl inspectionProfile = this.getSelectedObject();
        SingleInspectionProfilePanel panel = this.getProfilePanel(inspectionProfile);
        LOG.assertTrue(panel != null, (Object)("No settings panel for: " + inspectionProfile + "; " + this.configuredProfiles()));
        panel.selectInspectionTool(selectedToolShortName);
    }

    protected SingleInspectionProfilePanel getSelectedPanel() {
        InspectionProfileImpl inspectionProfile = this.getSelectedObject();
        return this.getProfilePanel(inspectionProfile);
    }

    private String configuredProfiles() {
        return "configured profiles: " + StringUtil.join(this.myPanels.keySet(), (String)", ");
    }

    private boolean hasName(@NotNull String name, boolean shared) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "hasName"));
        }
        for (SingleInspectionProfilePanel p : this.myPanels.values()) {
            if (!name.equals(p.getCurrentProfileName()) || shared != p.isProjectLevel()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public InspectionProfileImpl getSelectedObject() {
        InspectionProfileImpl inspectionProfileImpl = this.myProfiles.getSelectedProfile();
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "getSelectedObject"));
        }
        return inspectionProfileImpl;
    }

    public JComponent getPreferredFocusedComponent() {
        InspectionProfileImpl inspectionProfile = this.myProfiles.getSelectedProfile();
        SingleInspectionProfilePanel panel = this.getProfilePanel(inspectionProfile);
        return panel == null ? null : panel.getPreferredFocusedComponent();
    }
}

