/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockBuilder;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.LeafBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CommentWithInjectionBlock
extends AbstractJavaBlock {
    private final InjectedLanguageBlockBuilder myInjectedBlockBuilder = new JavaCommentInjectedBlockBuilder();

    public CommentWithInjectionBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        super(node, wrap, alignment, indent, settings, javaSettings);
    }

    @Override
    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>();
        this.myInjectedBlockBuilder.addInjectedBlocks(result, this.myNode, this.myWrap, this.myAlignment, Indent.getNoneIndent());
        return result;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/CommentWithInjectionBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    @Override
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/formatter/java/CommentWithInjectionBlock", "getSpacing"));
        }
        return null;
    }

    private static class PartialCommentBlock
    extends LeafBlock {
        private final TextRange myRange;

        public PartialCommentBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
            super(node, wrap, alignment, indent);
            this.myRange = range;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/CommentWithInjectionBlock$PartialCommentBlock", "getTextRange"));
            }
            return textRange;
        }
    }

    private class JavaCommentInjectedBlockBuilder
    extends InjectedLanguageBlockBuilder {
        private JavaCommentInjectedBlockBuilder() {
        }

        @Override
        public CodeStyleSettings getSettings() {
            return CommentWithInjectionBlock.this.mySettings.getRootSettings();
        }

        @Override
        public boolean canProcessFragment(String text, ASTNode injectionHost) {
            return true;
        }

        @Override
        public Block createBlockBeforeInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
            return new PartialCommentBlock(node, wrap, alignment, indent, range);
        }

        @Override
        public Block createBlockAfterInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
            return new PartialCommentBlock(node, wrap, alignment, Indent.getNoneIndent(), range);
        }
    }
}

