/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindSuperElementsHelper {
    @NotNull
    public static PsiElement[] findSuperElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            ArrayList<PsiClass> allSupers = new ArrayList<PsiClass>(Arrays.asList(aClass.getSupers()));
            Iterator iterator = allSupers.iterator();
            while (iterator.hasNext()) {
                PsiClass superClass = (PsiClass)iterator.next();
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) continue;
                iterator.remove();
            }
            PsiElement[] psiElementArray = (PsiElement[])allSupers.toArray(new PsiClass[allSupers.size()]);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
            }
            return psiElementArray;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor()) {
                PsiMethod constructorInSuper = PsiSuperMethodUtil.findConstructorInSuper((PsiMethod)method);
                if (constructorInSuper != null) {
                    PsiMethod[] psiMethodArray = new PsiMethod[]{constructorInSuper};
                    if (psiMethodArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
                    }
                    return psiMethodArray;
                }
            } else {
                PsiMethod superMethod;
                PsiMethod[] superMethods = method.findSuperMethods(false);
                if (superMethods.length == 0 && (superMethod = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method)) != null) {
                    superMethods = new PsiMethod[]{superMethod};
                }
                if (superMethods == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
                }
                return superMethods;
            }
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static PsiMethod getSiblingInheritedViaSubClass(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/FindSuperElementsHelper", "getSiblingInheritedViaSubClass"));
        }
        return (PsiMethod)Pair.getFirst(FindSuperElementsHelper.getSiblingInheritedViaSubClass(method, FindSuperElementsHelper.createSubClassCache()));
    }

    public static Pair<PsiMethod, PsiClass> getSiblingInheritedViaSubClass(@NotNull PsiMethod method, @NotNull Map<PsiClass, PsiClass> subClassCache) {
        boolean hasSubClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/FindSuperElementsHelper", "getSiblingInheritedViaSubClass"));
        }
        if (subClassCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClassCache", "com/intellij/psi/impl/FindSuperElementsHelper", "getSiblingInheritedViaSubClass"));
        }
        if (!method.hasModifierProperty("public")) {
            return null;
        }
        if (method.hasModifierProperty("static")) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        boolean bl = hasSubClass = containingClass != null && !containingClass.isInterface() && subClassCache.get(containingClass) != null;
        if (!hasSubClass) {
            return null;
        }
        if ("java.lang.Object".equals(containingClass.getQualifiedName())) {
            return null;
        }
        THashSet checkedInterfaces = new THashSet();
        checkedInterfaces.add(PsiAnchor.create((PsiElement)containingClass));
        Ref result = Ref.create();
        ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)containingClass.getUseScope(), (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new Processor<PsiClass>((Collection)checkedInterfaces, method, containingClass, result){
            final /* synthetic */ Collection val$checkedInterfaces;
            final /* synthetic */ PsiMethod val$method;
            final /* synthetic */ PsiClass val$containingClass;
            final /* synthetic */ Ref val$result;
            {
                this.val$checkedInterfaces = collection;
                this.val$method = psiMethod;
                this.val$containingClass = psiClass;
                this.val$result = ref;
            }

            public boolean process(PsiClass inheritor) {
                ProgressManager.checkCanceled();
                for (PsiClassType interfaceType : inheritor.getImplementsListTypes()) {
                    ProgressManager.checkCanceled();
                    PsiClassType.ClassResolveResult resolved = interfaceType.resolveGenerics();
                    PsiClass anInterface = resolved.getElement();
                    if (anInterface == null || !this.val$checkedInterfaces.add(PsiAnchor.create((PsiElement)anInterface))) continue;
                    for (PsiMethod superMethod : anInterface.findMethodsByName(this.val$method.getName(), true)) {
                        MethodSignature derivedSignature;
                        PsiElement navigationElement = superMethod.getNavigationElement();
                        if (!(navigationElement instanceof PsiMethod)) continue;
                        superMethod = (PsiMethod)navigationElement;
                        ProgressManager.checkCanceled();
                        PsiClass superInterface = superMethod.getContainingClass();
                        if (superInterface == null || this.val$containingClass.isInheritor(superInterface, true)) continue;
                        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.val$containingClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                        MethodSignature superSignature = superMethod.getSignature(substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superInterface, (PsiClass)inheritor, (PsiSubstitutor)substitutor));
                        boolean isOverridden = MethodSignatureUtil.isSubsignature((MethodSignature)superSignature, (MethodSignature)(derivedSignature = this.val$method.getSignature(PsiSubstitutor.EMPTY)));
                        if (!isOverridden) continue;
                        this.val$result.set((Object)Pair.create((Object)superMethod, (Object)inheritor));
                        return false;
                    }
                }
                return true;
            }
        });
        return (Pair)result.get();
    }

    @NotNull
    public static Map<PsiClass, PsiClass> createSubClassCache() {
        FactoryMap<PsiClass, PsiClass> factoryMap = new FactoryMap<PsiClass, PsiClass>(){

            @Nullable
            protected PsiClass create(PsiClass aClass) {
                return (PsiClass)ClassInheritorsSearch.search((PsiClass)aClass, (boolean)false).findFirst();
            }
        };
        if (factoryMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "createSubClassCache"));
        }
        return factoryMap;
    }
}

