/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaOverridingMethodsSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    public boolean execute(final @NotNull OverridingMethodsSearch.SearchParameters p, final @NotNull Processor<PsiMethod> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "execute"));
        }
        final PsiMethod method = p.getMethod();
        SearchScope scope = p.getScope();
        final PsiClass parentClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return method.getContainingClass();
            }
        });
        assert (parentClass != null);
        Processor<PsiClass> inheritorsProcessor = new Processor<PsiClass>(){

            public boolean process(final PsiClass inheritor) {
                PsiMethod found = (PsiMethod)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod>(){

                    @Nullable
                    public PsiMethod compute() {
                        return JavaOverridingMethodsSearcher.findOverridingMethod(inheritor, parentClass, method);
                    }
                });
                return found == null || consumer.process((Object)found) && p.isCheckDeep();
            }
        };
        return ClassInheritorsSearch.search((PsiClass)parentClass, (SearchScope)scope, (boolean)true).forEach((Processor)inheritorsProcessor);
    }

    @Nullable
    private static PsiMethod findOverridingMethod(PsiClass inheritor, @NotNull PsiClass parentClass, PsiMethod method) {
        MethodSignature signature;
        PsiMethod derived;
        PsiClass superClass;
        PsiMethod found;
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "findOverridingMethod"));
        }
        String name = method.getName();
        if (inheritor.findMethodsByName(name, false).length > 0 && (found = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)JavaOverridingMethodsSearcher.getSuperSignature(inheritor, parentClass, method), (boolean)false)) != null && JavaOverridingMethodsSearcher.isAcceptable(found, method)) {
            return found;
        }
        if (parentClass.isInterface() && !inheritor.isInterface() && (superClass = inheritor.getSuperClass()) != null && !superClass.isInheritor(parentClass, true) && superClass.findMethodsByName(name, true).length > 0 && (derived = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)inheritor, (PsiClass)superClass, (MethodSignature)(signature = JavaOverridingMethodsSearcher.getSuperSignature(inheritor, parentClass, method)), (boolean)true)) != null && JavaOverridingMethodsSearcher.isAcceptable(derived, method)) {
            return derived;
        }
        return null;
    }

    @NotNull
    private static MethodSignature getSuperSignature(PsiClass inheritor, @NotNull PsiClass parentClass, PsiMethod method) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "getSuperSignature"));
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)parentClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY, null);
        MethodSignature methodSignature = method.getSignature(substitutor != null ? substitutor : PsiSubstitutor.EMPTY);
        if (methodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "getSuperSignature"));
        }
        return methodSignature;
    }

    private static boolean isAcceptable(PsiMethod found, PsiMethod method) {
        return !found.hasModifierProperty("static") && (!method.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance((Project)found.getProject()).arePackagesTheSame((PsiElement)method.getContainingClass(), (PsiElement)found.getContainingClass()));
    }
}

