/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;

public class LexerEditorHighlighterLexer
extends LexerBase {
    private HighlighterIterator iterator;
    private CharSequence buffer;
    private int start;
    private int end;
    private final EditorHighlighter myHighlighter;
    private final boolean myAlreadyInitializedHighlighter;

    public LexerEditorHighlighterLexer(EditorHighlighter highlighter, boolean alreadyInitializedHighlighter) {
        this.myHighlighter = highlighter;
        this.myAlreadyInitializedHighlighter = alreadyInitializedHighlighter;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int state) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/search/LexerEditorHighlighterLexer", "start"));
        }
        if (this.myAlreadyInitializedHighlighter) {
            this.buffer = buffer;
            this.start = startOffset;
            this.end = endOffset;
        } else {
            this.buffer = buffer;
            this.start = startOffset;
            this.end = endOffset;
            this.myHighlighter.setText((CharSequence)new CharSequenceSubSequence(this.buffer, this.start, this.end));
        }
        this.iterator = this.myHighlighter.createIterator(0);
    }

    public void resetPosition(int offset) {
        this.iterator = this.myHighlighter.createIterator(offset);
    }

    public int getState() {
        return 0;
    }

    public IElementType getTokenType() {
        if (this.iterator.atEnd()) {
            return null;
        }
        return this.iterator.getTokenType();
    }

    public int getTokenStart() {
        return this.iterator.getStart();
    }

    public int getTokenEnd() {
        return this.iterator.getEnd();
    }

    public void advance() {
        this.iterator.advance();
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.buffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/LexerEditorHighlighterLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.end;
    }

    public HighlighterIterator getHighlighterIterator() {
        return this.iterator;
    }
}

