/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTokenType;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlConditionalCommentInjector
implements MultiHostInjector {
    public static boolean isConditionalComment(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/psi/impl/source/html/HtmlConditionalCommentInjector", "isConditionalComment"));
        }
        return HtmlConditionalCommentInjector.parseConditionalCommentBoundaries(host) != null;
    }

    @Nullable
    private static Pair<ASTNode, ASTNode> parseConditionalCommentBoundaries(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/psi/impl/source/html/HtmlConditionalCommentInjector", "parseConditionalCommentBoundaries"));
        }
        if (!(host instanceof XmlComment)) {
            return null;
        }
        ASTNode comment = host.getNode();
        if (comment == null) {
            return null;
        }
        ASTNode conditionalStart = comment.findChildByType(TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_CONDITIONAL_COMMENT_START_END}));
        if (conditionalStart == null) {
            return null;
        }
        ASTNode conditionalEnd = comment.findChildByType(TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_CONDITIONAL_COMMENT_END_START}));
        if (conditionalEnd == null) {
            return null;
        }
        ASTNode endOfEnd = comment.findChildByType(TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_CONDITIONAL_COMMENT_END}));
        return endOfEnd == null ? null : Pair.create((Object)conditionalStart, (Object)conditionalEnd);
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/psi/impl/source/html/HtmlConditionalCommentInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/psi/impl/source/html/HtmlConditionalCommentInjector", "getLanguagesToInject"));
        }
        Pair<ASTNode, ASTNode> pair = HtmlConditionalCommentInjector.parseConditionalCommentBoundaries(host);
        if (pair == null) {
            return;
        }
        TextRange textRange = host.getTextRange();
        int startOffset = textRange.getStartOffset();
        Language language = host.getParent().getLanguage();
        ASTNode conditionalStart = (ASTNode)pair.first;
        ASTNode conditionalEnd = (ASTNode)pair.second;
        UnfairTextRange range = new UnfairTextRange(conditionalStart.getTextRange().getEndOffset() - startOffset, conditionalEnd.getStartOffset() - startOffset);
        if (range.getStartOffset() < range.getEndOffset()) {
            registrar.startInjecting(language).addPlace(null, null, (PsiLanguageInjectionHost)host, (TextRange)range).doneInjecting();
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(PsiComment.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/html/HtmlConditionalCommentInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

