/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.annotations.NotNull;

public class ResolveVariableUtil {
    public static PsiVariable resolveVariable(@NotNull PsiJavaCodeReferenceElement ref, boolean[] problemWithAccess, boolean[] problemWithStatic) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveVariableUtil", "resolveVariable"));
        }
        VariableResolverProcessor processor2 = new VariableResolverProcessor(ref, ref.getContainingFile());
        PsiScopesUtil.resolveAndWalk(processor2, ref, null);
        JavaResolveResult[] result = processor2.getResult();
        if (result.length != 1) {
            return null;
        }
        PsiVariable refVar = (PsiVariable)result[0].getElement();
        if (problemWithAccess != null) {
            boolean bl = problemWithAccess[0] = !result[0].isAccessible();
        }
        if (problemWithStatic != null) {
            problemWithStatic[0] = !result[0].isStaticsScopeCorrect();
        }
        return refVar;
    }
}

