/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.stubsHierarchy.impl.HierarchyConnector;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.psi.stubsHierarchy.impl.SmartClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.Symbols;
import java.util.ArrayList;

public class PsiHierachyConnector
implements HierarchyConnector {
    private final NameEnvironment myNameEnvironment;
    private final Symbols mySymbols;

    protected PsiHierachyConnector(NameEnvironment nameEnvironment, Symbols symbols) {
        this.myNameEnvironment = nameEnvironment;
        this.mySymbols = symbols;
    }

    @Override
    public void connect(final Symbol sym) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiHierachyConnector.this.connectInternal((Symbol.ClassSymbol)sym);
            }
        });
    }

    private void connectInternal(Symbol.ClassSymbol sym) {
        if (sym.myOwner instanceof Symbol.ClassSymbol) {
            ((Symbol.ClassSymbol)sym.myOwner).connect();
        }
        sym.mySuperClasses = this.getSuperTypes(sym.myClassAnchor);
    }

    private Symbol.ClassSymbol[] asSymbol(PsiClass psiClass) {
        QualifiedName n;
        if (psiClass == null) {
            return Symbol.ClassSymbol.EMPTY_ARRAY;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName != null && (n = this.myNameEnvironment.fromString(qualifiedName, false)) != null) {
            return this.mySymbols.loadClass(n);
        }
        return Symbol.ClassSymbol.EMPTY_ARRAY;
    }

    Symbol.ClassSymbol[] getSuperTypes(SmartClassAnchor anchor) {
        PsiClass psiClass = ((SmartClassAnchor.DirectSmartClassAnchor)anchor).myPsiClass;
        PsiClass[] psiInterfaces = psiClass.getInterfaces();
        ArrayList<Symbol.ClassSymbol> superList = new ArrayList<Symbol.ClassSymbol>();
        for (PsiClass psiInterface : psiInterfaces) {
            for (Symbol.ClassSymbol cs : this.asSymbol(psiInterface)) {
                if (cs.myQualifiedName == this.myNameEnvironment.java_lang_Object) continue;
                superList.add(cs);
            }
        }
        PsiClass psiSuperClass = psiClass.getSuperClass();
        for (Symbol.ClassSymbol cs : this.asSymbol(psiSuperClass)) {
            if (cs.myQualifiedName == this.myNameEnvironment.java_lang_Object) continue;
            superList.add(cs);
        }
        if (superList.isEmpty()) {
            return Symbol.ClassSymbol.EMPTY_ARRAY;
        }
        return superList.isEmpty() ? Symbol.ClassSymbol.EMPTY_ARRAY : superList.toArray(new Symbol.ClassSymbol[superList.size()]);
    }
}

