/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubsHierarchy.impl.ClassAnchorUtil;
import com.intellij.psi.stubsHierarchy.impl.SmartClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntStack;
import java.util.Arrays;
import java.util.Comparator;

public class SingleClassHierarchy {
    public final SmartClassAnchor[] myClassAnchors;
    private final SmartClassAnchor[] myClassAnchorsByFileIds;
    private int[] mySubtypes;
    private int[] mySubtypeStarts;

    public SingleClassHierarchy(Symbol.ClassSymbol[] classSymbols, int symbolCount) {
        this.myClassAnchors = SingleClassHierarchy.mkAnchors(classSymbols, symbolCount);
        this.myClassAnchorsByFileIds = SingleClassHierarchy.mkByFileId(this.myClassAnchors);
    }

    public SmartClassAnchor[] getSubtypes(PsiClass psiClass) {
        int fileId = Math.abs(FileBasedIndex.getFileId((VirtualFile)psiClass.getContainingFile().getVirtualFile()));
        SmartClassAnchor anchor = this.forPsiClass(fileId, psiClass);
        if (anchor == null) {
            return SmartClassAnchor.EMPTY_ARRAY;
        }
        int symbolId = anchor.myId;
        int start = this.subtypeStart(symbolId);
        int end = this.subtypeEnd(symbolId);
        int length = end - start;
        if (length == 0) {
            return SmartClassAnchor.EMPTY_ARRAY;
        }
        SmartClassAnchor[] result = new SmartClassAnchor[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.myClassAnchors[this.mySubtypes[start + i]];
        }
        return result;
    }

    public SmartClassAnchor[] getAllSubtypes(PsiClass base) {
        int fileId = Math.abs(FileBasedIndex.getFileId((VirtualFile)base.getContainingFile().getVirtualFile()));
        TIntHashSet resultIds = new TIntHashSet();
        TIntHashSet processed2 = new TIntHashSet();
        TIntStack queue = new TIntStack();
        SmartClassAnchor baseAnchor = this.forPsiClass(fileId, base);
        if (baseAnchor == null) {
            return SmartClassAnchor.EMPTY_ARRAY;
        }
        queue.push(baseAnchor.myId);
        while (queue.size() > 0) {
            int id = queue.pop();
            if (!processed2.add(id)) continue;
            int start = this.subtypeStart(id);
            int end = this.subtypeEnd(id);
            for (int i = start; i < end; ++i) {
                int subtypeId = this.mySubtypes[i];
                resultIds.add(subtypeId);
                if (processed2.contains(subtypeId)) continue;
                queue.push(subtypeId);
            }
        }
        int[] allIds = resultIds.toArray();
        SmartClassAnchor[] result = new SmartClassAnchor[allIds.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.myClassAnchors[allIds[i]];
        }
        return result;
    }

    private static SmartClassAnchor[] mkAnchors(Symbol.ClassSymbol[] classSymbols, int symbolCount) {
        SmartClassAnchor[] anchors = new SmartClassAnchor[symbolCount];
        for (int i = 0; i < symbolCount; ++i) {
            anchors[i] = classSymbols[i].myClassAnchor;
        }
        return anchors;
    }

    private static SmartClassAnchor[] mkByFileId(SmartClassAnchor[] classAnchors) {
        SmartClassAnchor[] result = new SmartClassAnchor[classAnchors.length];
        SmartClassAnchor lastProcessedAnchor = null;
        int i = 0;
        for (SmartClassAnchor classAnchor : classAnchors) {
            if (lastProcessedAnchor == null || lastProcessedAnchor.myFileId != classAnchor.myFileId) {
                result[i++] = classAnchor;
            }
            lastProcessedAnchor = classAnchor;
        }
        result = Arrays.copyOf(result, i);
        Arrays.sort(result, new Comparator<SmartClassAnchor>(){

            @Override
            public int compare(SmartClassAnchor o1, SmartClassAnchor o2) {
                int i1 = o1.myFileId;
                int i2 = o2.myFileId;
                if (i1 < i2) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
        });
        return result;
    }

    void connectSubTypes(Symbol.ClassSymbol[] classSymbols, int n) {
        int[] sizes = SingleClassHierarchy.calculateSizes(classSymbols, n);
        int[] starts = new int[n];
        int count = 0;
        for (int i = 0; i < sizes.length; ++i) {
            starts[i] = count;
            count += sizes[i];
        }
        int[] subtypes = new int[count];
        int[] filled = new int[sizes.length];
        for (int subTypeId = 0; subTypeId < n; ++subTypeId) {
            Symbol.ClassSymbol subType = classSymbols[subTypeId];
            for (Symbol.ClassSymbol superType : subType.getSuperClasses()) {
                int superTypeId = superType.myClassAnchor.myId;
                subtypes[starts[superTypeId] + filled[superTypeId]] = subTypeId;
                int n2 = superTypeId;
                filled[n2] = filled[n2] + 1;
            }
        }
        this.mySubtypes = subtypes;
        this.mySubtypeStarts = starts;
    }

    private static int[] calculateSizes(Symbol.ClassSymbol[] classSymbols, int n) {
        int[] sizes = new int[n];
        for (int i = 1; i < n; ++i) {
            Symbol.ClassSymbol subType = classSymbols[i];
            for (Symbol.ClassSymbol superType : subType.getSuperClasses()) {
                int superTypeId;
                int n2 = superTypeId = superType.myClassAnchor.myId;
                sizes[n2] = sizes[n2] + 1;
            }
        }
        return sizes;
    }

    private int subtypeStart(int nameId) {
        return this.mySubtypeStarts[nameId];
    }

    private int subtypeEnd(int nameId) {
        return nameId + 1 >= this.mySubtypeStarts.length ? this.mySubtypes.length : this.mySubtypeStarts[nameId + 1];
    }

    private SmartClassAnchor forPsiClass(int fileId, PsiClass psiClass) {
        SmartClassAnchor anchor = SingleClassHierarchy.getFirst(fileId, this.myClassAnchorsByFileIds);
        if (anchor == null) {
            return null;
        }
        for (int id = anchor.myId; id < this.myClassAnchors.length; ++id) {
            SmartClassAnchor candidate = this.myClassAnchors[id];
            if (candidate.myFileId != fileId) {
                return null;
            }
            if (!psiClass.isEquivalentTo((PsiElement)ClassAnchorUtil.retrieveInReadAction(psiClass.getProject(), candidate))) continue;
            return candidate;
        }
        return null;
    }

    private static SmartClassAnchor getFirst(int fileId, SmartClassAnchor[] byFileIds) {
        int lo = 0;
        int hi = byFileIds.length - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            if (fileId < byFileIds[mid].myFileId) {
                hi = mid - 1;
                continue;
            }
            if (fileId > byFileIds[mid].myFileId) {
                lo = mid + 1;
                continue;
            }
            return byFileIds[mid];
        }
        return null;
    }
}

