/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.stubs;

import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.util.ArrayUtil;

public class Import {
    public static final long[] EMPTY_ARRAY = ArrayUtil.EMPTY_LONG_ARRAY;
    public static int onDemandMask = 0x20000000;
    public static int staticMask = 0x40000000;
    public static int mask = ~(onDemandMask | staticMask);

    public static int getAlias(long importMask) {
        return (int)(importMask >>> 32);
    }

    public static QualifiedName getFullName(long importMask, NameEnvironment nameEnvironment) {
        return nameEnvironment.qualifiedName(Import.getFullNameId(importMask));
    }

    private static int getFullNameId(long importMask) {
        int fullNameId = (int)importMask;
        return fullNameId &= mask;
    }

    public static boolean isOnDemand(long importMask) {
        return (importMask & (long)onDemandMask) != 0L;
    }

    public static boolean isStatic(long importMask) {
        return (importMask & (long)staticMask) != 0L;
    }

    public static long mkImport(QualifiedName fullname, boolean importStatic, boolean onDemand, int alias) {
        long lower = fullname.myId;
        if (importStatic) {
            lower |= (long)staticMask;
        }
        if (onDemand) {
            lower |= (long)onDemandMask;
        }
        return (long)alias << 32 | lower;
    }
}

