/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inCallers;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.inCallers.JavaMethodNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashSet;
import java.util.Set;

public class JavaCallerChooser
extends CallerChooserBase<PsiMethod> {
    public JavaCallerChooser(PsiMethod method, Project project2, String title, Tree previousTree, Consumer<Set<PsiMethod>> callback) {
        super(method, project2, title, previousTree, "dummy." + StdFileTypes.JAVA.getDefaultExtension(), callback);
    }

    protected JavaMethodNode createTreeNode(PsiMethod method, HashSet<PsiMethod> called, Runnable cancelCallback) {
        return new JavaMethodNode(method, (Set<PsiMethod>)called, this.myProject, cancelCallback);
    }

    protected PsiMethod[] findDeepestSuperMethods(PsiMethod method) {
        return method.findDeepestSuperMethods();
    }

    @Override
    protected String getEmptyCallerText() {
        return "Caller method text \nwith highlighted callee call would be shown here";
    }

    @Override
    protected String getEmptyCalleeText() {
        return "Callee method text would be shown here";
    }
}

