/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineToAnonymousClassHandler;
import com.intellij.refactoring.inline.InlineToAnonymousConstructorProcessor;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineToAnonymousClassProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineToAnonymousClassProcessor");
    private PsiClass myClass;
    private final PsiCall myCallToInline;
    private final boolean myInlineThisOnly;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;

    protected InlineToAnonymousClassProcessor(Project project2, PsiClass psiClass, @Nullable PsiCall callToInline, boolean inlineThisOnly, boolean searchInComments, boolean searchInNonJavaFiles) {
        super(project2);
        this.myClass = psiClass;
        this.myCallToInline = callToInline;
        this.myInlineThisOnly = inlineThisOnly;
        if (this.myInlineThisOnly) assert (this.myCallToInline != null);
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor", "createUsageViewDescriptor"));
        }
        InlineViewDescriptor inlineViewDescriptor = new InlineViewDescriptor((PsiElement)this.myClass);
        if (inlineViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor", "createUsageViewDescriptor"));
        }
        return inlineViewDescriptor;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        if (this.myInlineThisOnly) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo((PsiElement)this.myCallToInline)};
            if (usageInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor", "findUsages"));
            }
            return usageInfoArray;
        }
        HashSet<UsageInfo> usages = new HashSet<UsageInfo>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myClass)) {
            usages.add(new UsageInfo(reference.getElement()));
        }
        String qName = this.myClass.getQualifiedName();
        if (qName != null) {
            ArrayList<UsageInfo> nonCodeUsages = new ArrayList<UsageInfo>();
            if (this.mySearchInComments) {
                TextOccurrencesUtil.addUsagesInStringsAndComments((PsiElement)this.myClass, qName, nonCodeUsages, new NonCodeUsageInfoFactory((PsiElement)this.myClass, qName));
            }
            if (this.mySearchInNonJavaFiles) {
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myClass.getProject());
                TextOccurrencesUtil.addTextOccurences((PsiElement)this.myClass, qName, projectScope, nonCodeUsages, new NonCodeUsageInfoFactory((PsiElement)this.myClass, qName));
            }
            usages.addAll(nonCodeUsages);
        }
        UsageInfo[] usageInfoArray = usages.toArray(new UsageInfo[usages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor", "refreshElements"));
        }
        assert (elements.length == 1);
        this.myClass = (PsiClass)elements[0];
    }

    @Override
    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor", "isPreviewUsages"));
        }
        if (super.isPreviewUsages(usages)) {
            return true;
        }
        for (UsageInfo usage : usages) {
            if (!InlineToAnonymousClassProcessor.isForcePreview(usage)) continue;
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"occurrences.found.in.comments.strings.and.non.java.files"));
            return true;
        }
        return false;
    }

    private static boolean isForcePreview(UsageInfo usage) {
        PsiFile file2;
        if (usage.isNonCodeUsage) {
            return true;
        }
        PsiElement element = usage.getElement();
        return element != null && !((file2 = element.getContainingFile()) instanceof PsiJavaFile);
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor", "preprocessUsages"));
        }
        MultiMap<PsiElement, String> conflicts = this.getConflicts((UsageInfo[])refUsages.get());
        if (!conflicts.isEmpty()) {
            return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
        }
        return super.preprocessUsages(refUsages);
    }

    public MultiMap<PsiElement, String> getConflicts(UsageInfo[] usages) {
        final MultiMap result = new MultiMap();
        ReferencedElementsCollector collector = new ReferencedElementsCollector(){

            @Override
            protected void checkAddMember(@NotNull PsiMember member) {
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor$1", "checkAddMember"));
                }
                if (PsiTreeUtil.isAncestor((PsiElement)InlineToAnonymousClassProcessor.this.myClass, (PsiElement)member, (boolean)false)) {
                    return;
                }
                PsiModifierList modifierList = member.getModifierList();
                if (member.getContainingClass() == InlineToAnonymousClassProcessor.this.myClass.getSuperClass() && modifierList != null && modifierList.hasModifierProperty("protected")) {
                    return;
                }
                super.checkAddMember(member);
            }
        };
        InlineMethodProcessor.addInaccessibleMemberConflicts((PsiElement)this.myClass, usages, collector, (MultiMap<PsiElement, String>)result);
        this.myClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitParameter(PsiParameter parameter) {
                super.visitParameter(parameter);
                if (PsiUtil.resolveClassInType((PsiType)parameter.getType()) != InlineToAnonymousClassProcessor.this.myClass) {
                    return;
                }
                for (PsiReference psiReference : ReferencesSearch.search((PsiElement)parameter)) {
                    PsiElement resolvedMember;
                    PsiReferenceExpression referenceExpression;
                    PsiElement refElement = psiReference.getElement();
                    if (!(refElement instanceof PsiExpression) || (referenceExpression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)refElement, PsiReferenceExpression.class)) == null || referenceExpression.getQualifierExpression() != refElement || (resolvedMember = referenceExpression.resolve()) == null || !PsiTreeUtil.isAncestor((PsiElement)InlineToAnonymousClassProcessor.this.myClass, (PsiElement)resolvedMember, (boolean)false) || resolvedMember instanceof PsiMethod && InlineToAnonymousClassProcessor.this.myClass.findMethodsBySignature((PsiMethod)resolvedMember, true).length > 1) continue;
                    result.putValue((Object)refElement, (Object)"Class cannot be inlined because a call to its member inside body");
                }
            }

            public void visitNewExpression(PsiNewExpression expression) {
                super.visitNewExpression(expression);
                if (PsiUtil.resolveClassInType((PsiType)expression.getType()) != InlineToAnonymousClassProcessor.this.myClass) {
                    return;
                }
                result.putValue((Object)expression, (Object)"Class cannot be inlined because a call to its constructor inside body");
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiMethod method;
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (qualifierExpression != null && PsiUtil.resolveClassInType((PsiType)qualifierExpression.getType()) != InlineToAnonymousClassProcessor.this.myClass) {
                    return;
                }
                PsiElement resolved = methodExpression.resolve();
                if (resolved instanceof PsiMethod && "getClass".equals((method = (PsiMethod)resolved).getName()) && method.getParameterList().getParametersCount() == 0) {
                    result.putValue((Object)methodExpression, (Object)"Result of getClass() invocation would be changed");
                }
            }
        });
        return result;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor", "performRefactoring"));
        }
        PsiClassType superType = InlineToAnonymousClassProcessor.getSuperType(this.myClass);
        LOG.assertTrue(superType != null);
        ArrayList<PsiImportStatement> elementsToDelete = new ArrayList<PsiImportStatement>();
        ArrayList<PsiNewExpression> newExpressions = new ArrayList<PsiNewExpression>();
        for (UsageInfo info : usages) {
            PsiElement element = info.getElement();
            if (element instanceof PsiNewExpression) {
                newExpressions.add((PsiNewExpression)element);
                continue;
            }
            if (element.getParent() instanceof PsiNewExpression) {
                newExpressions.add((PsiNewExpression)element.getParent());
                continue;
            }
            PsiImportStatement statement2 = (PsiImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class);
            if (statement2 != null && !this.myInlineThisOnly) {
                elementsToDelete.add(statement2);
                continue;
            }
            PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeElement.class);
            if (typeElement == null) continue;
            this.replaceWithSuperType(typeElement, superType);
        }
        Collections.sort(newExpressions, PsiUtil.BY_POSITION);
        for (PsiNewExpression psiNewExpression : newExpressions) {
            this.replaceNewOrType(psiNewExpression, superType);
        }
        for (PsiElement psiElement : elementsToDelete) {
            try {
                if (!psiElement.isValid()) continue;
                psiElement.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!this.myInlineThisOnly) {
            try {
                this.myClass.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void replaceNewOrType(PsiNewExpression psiNewExpression, PsiClassType superType) {
        try {
            if (psiNewExpression.getArrayDimensions().length == 0 && psiNewExpression.getArrayInitializer() == null) {
                new InlineToAnonymousConstructorProcessor(this.myClass, psiNewExpression, (PsiType)superType).run();
            } else {
                PsiClass target = superType.resolve();
                assert (target != null) : superType;
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory();
                PsiJavaCodeReferenceElement element = factory.createClassReferenceElement(target);
                PsiJavaCodeReferenceElement reference = psiNewExpression.getClassReference();
                assert (reference != null) : psiNewExpression;
                reference.replace((PsiElement)element);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void replaceWithSuperType(PsiTypeElement typeElement, PsiClassType superType) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory();
        PsiClassType psiType = (PsiClassType)typeElement.getType();
        PsiClassType.ClassResolveResult classResolveResult = psiType.resolveGenerics();
        PsiType substType = classResolveResult.getSubstitutor().substitute((PsiType)superType);
        assert (classResolveResult.getElement() == this.myClass);
        try {
            PsiElement replaced = typeElement.replace((PsiElement)factory.createTypeElement(substType));
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(replaced);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public static PsiClassType getSuperType(PsiClass aClass) {
        PsiClassType superType;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        PsiClass superClass = aClass.getSuperClass();
        PsiClassType[] interfaceTypes = aClass.getImplementsListTypes();
        if (interfaceTypes.length > 0 && !InlineToAnonymousClassHandler.isRedundantImplements(superClass, interfaceTypes[0])) {
            superType = interfaceTypes[0];
        } else {
            PsiClassType[] classTypes = aClass.getExtendsListTypes();
            if (classTypes.length > 0) {
                superType = classTypes[0];
            } else {
                if (superClass == null) {
                    return null;
                }
                superType = factory.createType(superClass);
            }
        }
        return superType;
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"inline.to.anonymous.command.name", (Object[])new Object[]{this.myClass.getQualifiedName()});
    }
}

