/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldCentralPanel;
import com.intellij.refactoring.introduceField.IntroduceFieldDialogPanel;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.NameSuggestionsManager;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IntroduceFieldDialog
extends DialogWrapper {
    public static BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace;
    private final Project myProject;
    private final PsiClass myParentClass;
    private final PsiExpression myInitializerExpression;
    private final String myEnteredName;
    private final PsiLocalVariable myLocalVariable;
    private final boolean myIsInvokedOnDeclaration;
    private final boolean myWillBeDeclaredStatic;
    private final TypeSelectorManager myTypeSelectorManager;
    private NameSuggestionsField myNameField;
    private final IntroduceFieldCentralPanel myCentralPanel;
    private TypeSelector myTypeSelector;
    private NameSuggestionsManager myNameSuggestionsManager;
    private static final String REFACTORING_NAME;

    public IntroduceFieldDialog(Project project2, PsiClass parentClass, PsiExpression initializerExpression, PsiLocalVariable localVariable, boolean isCurrentMethodConstructor, boolean isInvokedOnDeclaration, boolean willBeDeclaredStatic, PsiExpression[] occurrences, boolean allowInitInMethod, boolean allowInitInMethodIfAll, TypeSelectorManager typeSelectorManager, String enteredName) {
        super(project2, true);
        this.myProject = project2;
        this.myParentClass = parentClass;
        this.myInitializerExpression = initializerExpression;
        this.myEnteredName = enteredName;
        this.myCentralPanel = new IntroduceFieldDialogPanel(parentClass, initializerExpression, localVariable, isCurrentMethodConstructor, isInvokedOnDeclaration, willBeDeclaredStatic, occurrences, allowInitInMethod, allowInitInMethodIfAll, typeSelectorManager);
        this.myLocalVariable = localVariable;
        this.myIsInvokedOnDeclaration = isInvokedOnDeclaration;
        this.myWillBeDeclaredStatic = willBeDeclaredStatic;
        this.myTypeSelectorManager = typeSelectorManager;
        this.setTitle(REFACTORING_NAME);
        this.init();
        this.myCentralPanel.initializeControls(initializerExpression, ourLastInitializerPlace);
        this.updateButtons();
    }

    public void setReplaceAllOccurrences(boolean replaceAll) {
        this.myCentralPanel.setReplaceAllOccurrences(replaceAll);
    }

    public String getEnteredName() {
        return this.myNameField.getEnteredName();
    }

    public BaseExpressionToFieldHandler.InitializationPlace getInitializerPlace() {
        return this.myCentralPanel.getInitializerPlace();
    }

    @PsiModifier.ModifierConstant
    public String getFieldVisibility() {
        return this.myCentralPanel.getFieldVisibility();
    }

    public boolean isReplaceAllOccurrences() {
        return this.myCentralPanel.isReplaceAllOccurrences();
    }

    public boolean isDeleteVariable() {
        return this.myCentralPanel.isDeleteVariable();
    }

    public boolean isDeclareFinal() {
        return this.myCentralPanel.isDeclareFinal();
    }

    public PsiType getFieldType() {
        return this.myTypeSelector.getSelectedType();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceField/IntroduceFieldDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 4, 4, 0);
        gbConstraints.anchor = 13;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        final JLabel type = new JLabel(this.getTypeLabel());
        panel.add((Component)type, gbConstraints);
        ++gbConstraints.gridx;
        gbConstraints.insets = new Insets(4, 0, 4, 4);
        gbConstraints.weightx = 0.0;
        this.myTypeSelector = this.myTypeSelectorManager.getTypeSelector();
        panel.add((Component)this.myTypeSelector.getComponent(), gbConstraints);
        gbConstraints.insets = new Insets(4, 4, 4, 0);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        final JLabel namePrompt = new JLabel(RefactoringBundle.message((String)"name.prompt"));
        panel.add((Component)namePrompt, gbConstraints);
        gbConstraints.insets = new Insets(4, 0, 4, 4);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 1;
        this.myNameField = new NameSuggestionsField(this.myProject);
        panel.add((Component)this.myNameField.getComponent(), gbConstraints);
        this.myNameField.addDataChangedListener(new NameSuggestionsField.DataChanged(){

            @Override
            public void dataChanged() {
                IntroduceFieldDialog.this.updateButtons();
            }
        });
        namePrompt.setLabelFor(this.myNameField.getFocusableComponent());
        new UiNotifyConnector.Once((Component)panel, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                IntroduceFieldDialog.this.myNameSuggestionsManager = new NameSuggestionsManager(IntroduceFieldDialog.this.myTypeSelector, IntroduceFieldDialog.this.myNameField, IntroduceFieldDialog.createGenerator(IntroduceFieldDialog.this.myWillBeDeclaredStatic, IntroduceFieldDialog.this.myLocalVariable, IntroduceFieldDialog.this.myInitializerExpression, IntroduceFieldDialog.this.myIsInvokedOnDeclaration, IntroduceFieldDialog.this.myEnteredName, IntroduceFieldDialog.this.myParentClass, IntroduceFieldDialog.this.myProject));
                IntroduceFieldDialog.this.myNameSuggestionsManager.setLabelsFor(type, namePrompt);
                Editor editor = IntroduceFieldDialog.this.myNameField.getEditor();
                if (editor != null) {
                    editor.getSelectionModel().setSelection(0, editor.getDocument().getTextLength());
                }
            }
        });
        return panel;
    }

    private void updateButtons() {
        this.setOKActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(this.getEnteredName()));
    }

    private String getTypeLabel() {
        return this.myWillBeDeclaredStatic ? RefactoringBundle.message((String)"introduce.field.static.field.of.type") : RefactoringBundle.message((String)"introduce.field.field.of.type");
    }

    protected JComponent createCenterPanel() {
        return this.myCentralPanel.createCenterPanel();
    }

    static NameSuggestionsGenerator createGenerator(final boolean willBeDeclaredStatic, final PsiLocalVariable localVariable, final PsiExpression initializerExpression, final boolean isInvokedOnDeclaration, final @Nullable String enteredName, final PsiClass parentClass, final Project project2) {
        return new NameSuggestionsGenerator(){
            private final JavaCodeStyleManager myCodeStyleManager;
            {
                this.myCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            }

            @Override
            public SuggestedNameInfo getSuggestedNameInfo(PsiType type) {
                VariableKind variableKind = willBeDeclaredStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
                String propertyName = null;
                if (isInvokedOnDeclaration) {
                    propertyName = this.myCodeStyleManager.variableNameToPropertyName(localVariable.getName(), VariableKind.LOCAL_VARIABLE);
                }
                SuggestedNameInfo nameInfo = this.myCodeStyleManager.suggestVariableName(variableKind, propertyName, initializerExpression, type);
                if (initializerExpression != null) {
                    for (String name : nameInfo.names) {
                        if (parentClass.findFieldByName(name, false) == null) continue;
                        names[i] = this.myCodeStyleManager.suggestUniqueVariableName(name, (PsiElement)initializerExpression, true);
                    }
                }
                String[] strings = AbstractJavaInplaceIntroducer.appendUnresolvedExprName(JavaCompletionUtil.completeVariableNameForRefactoring(this.myCodeStyleManager, type, VariableKind.LOCAL_VARIABLE, nameInfo), initializerExpression);
                return new SuggestedNameInfo.Delegate(enteredName != null ? ArrayUtil.mergeArrays((String[])new String[]{enteredName}, (String[])strings) : strings, nameInfo);
            }
        };
    }

    protected void doOKAction() {
        int answer;
        String fieldName = this.getEnteredName();
        String errorString = null;
        if ("".equals(fieldName)) {
            errorString = RefactoringBundle.message((String)"no.field.name.specified");
        } else if (!PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(fieldName)) {
            errorString = RefactoringMessageUtil.getIncorrectIdentifierMessage(fieldName);
        }
        if (errorString != null) {
            CommonRefactoringUtil.showErrorMessage((String)IntroduceFieldHandler.REFACTORING_NAME, (String)errorString, (String)"refactoring.introduceField", (Project)this.myProject);
            return;
        }
        PsiField oldField = this.myParentClass.findFieldByName(fieldName, true);
        if (oldField != null && (answer = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"field.exists", (Object[])new Object[]{fieldName, oldField.getContainingClass().getQualifiedName()}), (String)IntroduceFieldHandler.REFACTORING_NAME, (Icon)Messages.getWarningIcon())) != 0) {
            return;
        }
        this.myCentralPanel.saveFinalState();
        ourLastInitializerPlace = this.myCentralPanel.getInitializerPlace();
        JavaRefactoringSettings.getInstance().INTRODUCE_FIELD_VISIBILITY = this.getFieldVisibility();
        this.myNameSuggestionsManager.nameSelected();
        this.myTypeSelectorManager.typeSelected(this.getFieldType());
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.introduceField");
    }

    static {
        REFACTORING_NAME = RefactoringBundle.message((String)"introduce.field.title");
    }
}

