/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.NameSuggestionsManager;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.StateRestoringCheckBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class IntroduceVariableDialog
extends DialogWrapper
implements IntroduceVariableSettings {
    private final Project myProject;
    private final PsiExpression myExpression;
    private final int myOccurrencesCount;
    private final boolean myAnyLValueOccurences;
    private final boolean myDeclareFinalIfAll;
    private final TypeSelectorManager myTypeSelectorManager;
    private final IntroduceVariableBase.Validator myValidator;
    private NameSuggestionsField myNameField;
    private JCheckBox myCbReplaceAll;
    private StateRestoringCheckBox myCbReplaceWrite = null;
    private JCheckBox myCbFinal;
    private boolean myCbFinalState;
    private TypeSelector myTypeSelector;
    private NameSuggestionsManager myNameSuggestionsManager;
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.variable.title");
    private NameSuggestionsField.DataChanged myNameChangedListener;
    private ItemListener myReplaceAllListener;
    private ItemListener myFinalListener;

    public IntroduceVariableDialog(Project project2, PsiExpression expression, int occurrencesCount, boolean anyLValueOccurences, boolean declareFinalIfAll, TypeSelectorManager typeSelectorManager, IntroduceVariableBase.Validator validator) {
        super(project2, true);
        this.myProject = project2;
        this.myExpression = expression;
        this.myOccurrencesCount = occurrencesCount;
        this.myAnyLValueOccurences = anyLValueOccurences;
        this.myDeclareFinalIfAll = declareFinalIfAll;
        this.myTypeSelectorManager = typeSelectorManager;
        this.myValidator = validator;
        this.setTitle(REFACTORING_NAME);
        this.init();
    }

    protected void dispose() {
        this.myNameField.removeDataChangedListener(this.myNameChangedListener);
        if (this.myCbReplaceAll != null) {
            this.myCbReplaceAll.removeItemListener(this.myReplaceAllListener);
        }
        this.myCbFinal.removeItemListener(this.myFinalListener);
        super.dispose();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceVariable/IntroduceVariableDialog", "createActions"));
        }
        return actionArray;
    }

    protected void init() {
        super.init();
        this.updateOkStatus();
    }

    @Override
    public String getEnteredName() {
        return this.myNameField.getEnteredName();
    }

    @Override
    public boolean isReplaceAllOccurrences() {
        if (this.myOccurrencesCount <= 1) {
            return false;
        }
        return this.myCbReplaceAll.isSelected();
    }

    @Override
    public boolean isDeclareFinal() {
        return this.myCbFinal.isSelected();
    }

    @Override
    public boolean isReplaceLValues() {
        if (this.myOccurrencesCount <= 1 || !this.myAnyLValueOccurences || this.myCbReplaceWrite == null) {
            return true;
        }
        return this.myCbReplaceWrite.isSelected();
    }

    @Override
    public PsiType getSelectedType() {
        return this.myTypeSelector.getSelectedType();
    }

    protected JComponent createNorthPanel() {
        this.myNameField = new NameSuggestionsField(this.myProject);
        this.myNameChangedListener = new NameSuggestionsField.DataChanged(){

            @Override
            public void dataChanged() {
                IntroduceVariableDialog.this.updateOkStatus();
            }
        };
        this.myNameField.addDataChangedListener(this.myNameChangedListener);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 4, 4, 4);
        gbConstraints.anchor = 17;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        JLabel type = new JLabel(RefactoringBundle.message((String)"variable.of.type"));
        panel.add((Component)type, gbConstraints);
        ++gbConstraints.gridx;
        this.myTypeSelector = this.myTypeSelectorManager.getTypeSelector();
        panel.add((Component)this.myTypeSelector.getComponent(), gbConstraints);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        JLabel namePrompt = new JLabel(RefactoringBundle.message((String)"name.prompt"));
        namePrompt.setLabelFor(this.myNameField.getComponent());
        panel.add((Component)namePrompt, gbConstraints);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 1;
        panel.add((Component)this.myNameField.getComponent(), gbConstraints);
        this.myNameSuggestionsManager = new NameSuggestionsManager(this.myTypeSelector, this.myNameField, new NameSuggestionsGenerator(){

            @Override
            public SuggestedNameInfo getSuggestedNameInfo(PsiType type) {
                return IntroduceVariableBase.getSuggestedName(type, IntroduceVariableDialog.this.myExpression);
            }
        });
        this.myNameSuggestionsManager.setLabelsFor(type, namePrompt);
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        if (this.myOccurrencesCount > 1) {
            this.myCbReplaceAll = new NonFocusableCheckBox();
            this.myCbReplaceAll.setText(RefactoringBundle.message((String)"replace.all.occurences", (Object[])new Object[]{this.myOccurrencesCount}));
            panel.add((Component)this.myCbReplaceAll, gbConstraints);
            this.myReplaceAllListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    IntroduceVariableDialog.this.updateControls();
                }
            };
            this.myCbReplaceAll.addItemListener(this.myReplaceAllListener);
            if (this.myAnyLValueOccurences) {
                this.myCbReplaceWrite = new StateRestoringCheckBox();
                this.myCbReplaceWrite.setText(RefactoringBundle.message((String)"replace.write.access.occurrences"));
                gbConstraints.insets = new Insets(0, 8, 0, 0);
                ++gbConstraints.gridy;
                panel.add((Component)this.myCbReplaceWrite, gbConstraints);
                this.myCbReplaceWrite.addItemListener(this.myReplaceAllListener);
            }
        }
        this.myCbFinal = new NonFocusableCheckBox();
        this.myCbFinal.setText(RefactoringBundle.message((String)"declare.final"));
        Boolean createFinals = JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS;
        this.myCbFinalState = createFinals == null ? CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_LOCALS : createFinals;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        ++gbConstraints.gridy;
        panel.add((Component)this.myCbFinal, gbConstraints);
        this.myFinalListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (IntroduceVariableDialog.this.myCbFinal.isEnabled()) {
                    IntroduceVariableDialog.this.myCbFinalState = IntroduceVariableDialog.this.myCbFinal.isSelected();
                }
            }
        };
        this.myCbFinal.addItemListener(this.myFinalListener);
        this.updateControls();
        return panel;
    }

    private void updateControls() {
        if (this.myCbReplaceWrite != null) {
            if (this.myCbReplaceAll.isSelected()) {
                this.myCbReplaceWrite.makeSelectable();
            } else {
                this.myCbReplaceWrite.makeUnselectable(true);
            }
        }
        if (this.myCbReplaceAll != null) {
            this.myTypeSelectorManager.setAllOccurrences(this.myCbReplaceAll.isSelected());
        } else {
            this.myTypeSelectorManager.setAllOccurrences(false);
        }
        if (this.myDeclareFinalIfAll && this.myCbReplaceAll != null && this.myCbReplaceAll.isSelected()) {
            this.myCbFinal.setEnabled(false);
            this.myCbFinal.setSelected(true);
        } else if (this.myCbReplaceWrite != null && this.myCbReplaceWrite.isEnabled() && this.myCbReplaceWrite.isSelected()) {
            this.myCbFinal.setEnabled(false);
            this.myCbFinal.setSelected(false);
        } else {
            this.myCbFinal.setEnabled(true);
            this.myCbFinal.setSelected(this.myCbFinalState);
        }
    }

    protected void doOKAction() {
        if (!this.myValidator.isOK(this)) {
            return;
        }
        this.myNameSuggestionsManager.nameSelected();
        this.myTypeSelectorManager.typeSelected(this.getSelectedType());
        if (this.myCbFinal.isEnabled()) {
            JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS = this.myCbFinal.isSelected();
        }
        super.doOKAction();
    }

    private void updateOkStatus() {
        String text = this.getEnteredName();
        this.setOKActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(text));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.introduceVariable");
    }
}

