/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.tokenindex.LanguageTokenizer;
import com.intellij.tokenindex.Tokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchUtil {
    private static LanguageFileType ourDefaultFileType = null;
    public static boolean ourUseUniversalMatchingAlgorithm = false;
    private static StructuralSearchProfile[] ourNewStyleProfiles;
    private static List<Configuration> ourPredefinedConfigurations;

    private StructuralSearchUtil() {
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/StructuralSearchUtil", "getProfileByPsiElement"));
        }
        return StructuralSearchUtil.getProfileByLanguage(element.getLanguage());
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element) {
        if (element == null) {
            return false;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile != null && profile.isIdentifier(element);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element) {
        return !StructuralSearchUtil.isIdentifier(element) ? element : element.getParent();
    }

    @NotNull
    public static PsiElement getPresentableElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/StructuralSearchUtil", "getPresentableElement"));
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        if (profile == null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchUtil", "getPresentableElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = StructuralSearchUtil.getParentIfIdentifier(profile.getPresentableElement(element));
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchUtil", "getPresentableElement"));
        }
        return psiElement;
    }

    private static StructuralSearchProfile[] getNewStyleProfiles() {
        if (ourNewStyleProfiles == null) {
            ArrayList<StructuralSearchProfile> list = new ArrayList<StructuralSearchProfile>();
            for (StructuralSearchProfile profile : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
                if (!(profile instanceof StructuralSearchProfileBase)) continue;
                list.add(profile);
            }
            list.add(new XmlStructuralSearchProfile());
            ourNewStyleProfiles = list.toArray(new StructuralSearchProfile[list.size()]);
        }
        return ourNewStyleProfiles;
    }

    private static StructuralSearchProfile[] getProfiles() {
        return ourUseUniversalMatchingAlgorithm ? StructuralSearchUtil.getNewStyleProfiles() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    public static FileType getDefaultFileType() {
        if (ourDefaultFileType == null) {
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                ourDefaultFileType = profile.getDefaultFileType(ourDefaultFileType);
            }
            if (ourDefaultFileType == null) {
                ourDefaultFileType = StdFileTypes.XML;
            }
        }
        assert (ourDefaultFileType instanceof LanguageFileType) : "file type not valid for structural search: " + ourDefaultFileType.getName();
        return ourDefaultFileType;
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/structuralsearch/StructuralSearchUtil", "getProfileByLanguage"));
        }
        for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
            if (!profile.isMyLanguage(language)) continue;
            return profile;
        }
        return null;
    }

    @Nullable
    public static Tokenizer getTokenizerForLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/structuralsearch/StructuralSearchUtil", "getTokenizerForLanguage"));
        }
        return (Tokenizer)LanguageTokenizer.INSTANCE.forLanguage(language);
    }

    public static boolean isTypedVariable(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/structuralsearch/StructuralSearchUtil", "isTypedVariable"));
        }
        return name.length() > 1 && name.charAt(0) == '$' && name.charAt(name.length() - 1) == '$';
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(FileType fileType) {
        for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
            if (!profile.canProcess(fileType)) continue;
            return profile;
        }
        return null;
    }

    @NotNull
    public static FileType[] getSuitableFileTypes() {
        HashSet<LanguageFileType> allFileTypes = new HashSet<LanguageFileType>();
        Collections.addAll(allFileTypes, FileTypeManager.getInstance().getRegisteredFileTypes());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType = language.getAssociatedFileType();
            if (fileType == null) continue;
            allFileTypes.add(fileType);
        }
        ArrayList<LanguageFileType> result = new ArrayList<LanguageFileType>();
        for (LanguageFileType fileType : allFileTypes) {
            if (!(fileType instanceof LanguageFileType)) continue;
            result.add(fileType);
        }
        FileType[] fileTypeArray = result.toArray(new FileType[result.size()]);
        if (fileTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchUtil", "getSuitableFileTypes"));
        }
        return fileTypeArray;
    }

    public static String shieldSpecialChars(String word) {
        StringBuilder buf = new StringBuilder(word.length());
        for (int i = 0; i < word.length(); ++i) {
            if ("*(){}[]^$\\.-|".indexOf(word.charAt(i)) != -1) {
                buf.append("\\");
            }
            buf.append(word.charAt(i));
        }
        return buf.toString();
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (ourPredefinedConfigurations == null) {
            ArrayList result = new ArrayList();
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                Collections.addAll(result, profile.getPredefinedTemplates());
            }
            Collections.sort(result);
            ourPredefinedConfigurations = Collections.unmodifiableList(result);
        }
        return ourPredefinedConfigurations;
    }

    public static boolean isDocCommentOwner(PsiElement match) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(match);
        return profile != null && profile.isDocCommentOwner(match);
    }

    static {
        ourPredefinedConfigurations = null;
    }
}

