/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.iterators;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.structuralsearch.impl.matcher.MatchUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class HierarchyNodeIterator
extends NodeIterator {
    private int index;
    private ArrayList<PsiElement> remaining = new ArrayList();
    private boolean objectTaken;
    private boolean firstElementTaken;
    private final boolean acceptClasses;
    private final boolean acceptInterfaces;
    private final boolean acceptFirstElement;

    private void build(PsiElement current, Set<PsiElement> visited) {
        if (current != null) {
            PsiElement element;
            String str;
            String string = str = current instanceof PsiClass ? ((PsiClass)current).getName() : current.getText();
            if (MatchUtils.compareWithNoDifferenceToPackage(str, "Object")) {
                if (this.objectTaken) {
                    return;
                }
                this.objectTaken = true;
            }
            if ((element = MatchUtils.getReferencedElement(current)) instanceof PsiClass) {
                if (visited.contains(element)) {
                    return;
                }
                PsiClass clazz = (PsiClass)element;
                if (this.acceptInterfaces || !clazz.isInterface()) {
                    visited.add(element);
                }
                if (!this.firstElementTaken && this.acceptFirstElement || this.firstElementTaken) {
                    this.remaining.add((PsiElement)clazz);
                }
                this.firstElementTaken = true;
                if (clazz instanceof PsiAnonymousClass) {
                    this.build((PsiElement)((PsiAnonymousClass)clazz).getBaseClassReference(), visited);
                    return;
                }
                if (this.acceptClasses) {
                    this.processClasses(clazz, visited);
                    if (!this.objectTaken) {
                        this.build((PsiElement)PsiClassImplUtil.getSuperClass(clazz), visited);
                    }
                }
                if (this.acceptInterfaces) {
                    PsiReferenceList implementsList = clazz.getImplementsList();
                    if (implementsList != null) {
                        PsiJavaCodeReferenceElement[] implementsListElements;
                        for (PsiJavaCodeReferenceElement anImplementsList : implementsListElements = implementsList.getReferenceElements()) {
                            this.build((PsiElement)anImplementsList, visited);
                        }
                    }
                    if (!this.acceptClasses) {
                        this.processClasses(clazz, visited);
                    }
                }
            } else {
                this.remaining.add(current);
            }
        }
    }

    private void processClasses(PsiClass clazz, Set<PsiElement> visited) {
        PsiJavaCodeReferenceElement[] extendsList;
        PsiReferenceList clazzExtendsList = clazz.getExtendsList();
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = extendsList = clazzExtendsList != null ? clazzExtendsList.getReferenceElements() : null;
        if (extendsList != null) {
            for (PsiJavaCodeReferenceElement anExtendsList : extendsList) {
                this.build((PsiElement)anExtendsList, visited);
            }
        }
    }

    public HierarchyNodeIterator(PsiElement reference, boolean acceptClasses, boolean acceptInterfaces) {
        this(reference, acceptClasses, acceptInterfaces, true);
    }

    public HierarchyNodeIterator(PsiElement reference, boolean acceptClasses, boolean acceptInterfaces, boolean acceptFirstElement) {
        this.acceptClasses = acceptClasses;
        this.acceptInterfaces = acceptInterfaces;
        this.acceptFirstElement = acceptFirstElement;
        if (reference instanceof PsiIdentifier) {
            reference = reference.getParent();
        }
        this.build(reference, new HashSet<PsiElement>());
    }

    @Override
    public boolean hasNext() {
        return this.index < this.remaining.size();
    }

    @Override
    public PsiElement current() {
        return this.remaining.get(this.index);
    }

    @Override
    public void advance() {
        if (this.index != this.remaining.size()) {
            ++this.index;
        }
    }

    @Override
    public void rewind() {
        if (this.index > 0) {
            --this.index;
        }
    }

    @Override
    public void reset() {
        this.index = 0;
    }
}

