/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.UsefulTestCase;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LexerTestCase
extends UsefulTestCase {
    protected void doTest(@NonNls String text) {
        this.doTest(text, null);
    }

    protected void doTest(@NonNls String text, @Nullable String expected) {
        this.doTest(text, expected, this.createLexer());
    }

    protected void doTest(@NonNls String text, @Nullable String expected, @NotNull Lexer lexer) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/testFramework/LexerTestCase", "doTest"));
        }
        String result = LexerTestCase.printTokens(text, 0, lexer);
        if (expected != null) {
            LexerTestCase.assertSameLines(expected, result);
        } else {
            LexerTestCase.assertSameLinesWithFile(PathManager.getHomePath() + "/" + this.getDirPath() + "/" + this.getTestName(true) + ".txt", result);
        }
    }

    protected void checkZeroState(String text, TokenSet tokenTypes) {
        IElementType type;
        Lexer lexer = this.createLexer();
        lexer.start((CharSequence)text);
        while ((type = lexer.getTokenType()) != null) {
            if (tokenTypes.contains(type) && lexer.getState() != 0) {
                LexerTestCase.fail((String)("Non-zero lexer state on token \"" + lexer.getTokenText() + "\" (" + type + ") at " + lexer.getTokenStart()));
            }
            lexer.advance();
        }
    }

    protected void checkCorrectRestart(String text) {
        IElementType type;
        Lexer mainLexer = this.createLexer();
        String allTokens = LexerTestCase.printTokens(text, 0, mainLexer);
        Lexer auxLexer = this.createLexer();
        auxLexer.start((CharSequence)text);
        while ((type = auxLexer.getTokenType()) != null) {
            int tokenStart;
            String subTokens;
            if (auxLexer.getState() == 0 && !allTokens.endsWith(subTokens = LexerTestCase.printTokens(text, tokenStart = auxLexer.getTokenStart(), mainLexer))) {
                LexerTestCase.assertEquals((String)("Restarting impossible from offset " + tokenStart + "; lexer state should not return 0 at this point"), (String)allTokens, (String)subTokens);
            }
            auxLexer.advance();
        }
    }

    protected String printTokens(String text, int start) {
        return LexerTestCase.printTokens(text, start, this.createLexer());
    }

    public static String printTokens(CharSequence text, int start, Lexer lexer) {
        IElementType tokenType;
        lexer.start(text, start, text.length());
        String result = "";
        while ((tokenType = lexer.getTokenType()) != null) {
            String tokenText = LexerTestCase.getTokenText(lexer);
            String tokenTypeName = tokenType.toString();
            String line = tokenTypeName + " ('" + tokenText + "')\n";
            result = result + line;
            lexer.advance();
        }
        return result;
    }

    protected void doFileTest(@NonNls String fileExt) {
        String fileName = PathManager.getHomePath() + "/" + this.getDirPath() + "/" + this.getTestName(true) + "." + fileExt;
        String text = "";
        try {
            String fileText = FileUtil.loadFile((File)new File(fileName));
            text = StringUtil.convertLineSeparators((String)(this.shouldTrim() ? fileText.trim() : fileText));
        }
        catch (IOException e) {
            LexerTestCase.fail((String)("can't load file " + fileName + ": " + e.getMessage()));
        }
        this.doTest(text);
    }

    protected boolean shouldTrim() {
        return true;
    }

    private static String getTokenText(Lexer lexer) {
        IElementType tokenType = lexer.getTokenType();
        if (tokenType instanceof TokenWrapper) {
            return ((TokenWrapper)tokenType).getValue();
        }
        String text = lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
        text = StringUtil.replace((String)text, (String)"\n", (String)"\\n");
        return text;
    }

    protected abstract Lexer createLexer();

    protected abstract String getDirPath();
}

