/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.testIntegration.DeadTestsCleaner;
import com.intellij.testIntegration.RecentTestRunnerImpl;
import com.intellij.testIntegration.RecentTestsListPopup;
import com.intellij.testIntegration.RecentTestsListProvider;
import com.intellij.testIntegration.SelectTestStep;
import com.intellij.testIntegration.TestLocator;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ShowRecentTests
extends AnAction {
    private static final int TEST_LIMIT = Integer.MAX_VALUE;

    private static Date getSinceDate() {
        return new Date(System.currentTimeMillis() - 86400000L);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/testIntegration/ShowRecentTests", "update"));
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        TestStateStorage testStorage = TestStateStorage.getInstance(project2);
        TestLocator testLocator = new TestLocator(project2);
        RecentTestRunnerImpl testRunner = new RecentTestRunnerImpl();
        final Map<String, TestStateStorage.Record> records = testStorage.getRecentTests(Integer.MAX_VALUE, ShowRecentTests.getSinceDate());
        RecentTestsListProvider listProvider = new RecentTestsListProvider(records);
        List<String> urls = listProvider.getUrlsToShowFromHistory();
        Map icons = ContainerUtil.map2Map(urls, (Function)new Function<String, Pair<String, Icon>>(){

            public Pair<String, Icon> fun(String url) {
                return Pair.create((Object)url, (Object)ShowRecentTests.getIconFor(url, records));
            }
        });
        SelectTestStep selectStepTest = new SelectTestStep(urls, icons, testRunner, testLocator);
        RecentTestsListPopup popup = new RecentTestsListPopup((ListPopupStep<String>)selectStepTest, testRunner, testLocator);
        popup.showCenteredInCurrentWindow(project2);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new DeadTestsCleaner(testStorage, urls, testLocator));
    }

    private static Icon getIconFor(String value, Map<String, TestStateStorage.Record> records) {
        TestStateStorage.Record record = records.get(value);
        TestStateInfo.Magnitude magnitude = TestIconMapper.getMagnitude((int)record.magnitude);
        return TestIconMapper.getIcon((TestStateInfo.Magnitude)magnitude);
    }
}

