/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testIntegration.TestInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Date;
import java.util.List;
import java.util.Set;

class SuiteInfo
extends TestInfo {
    private final String mySuiteName;
    private Set<TestInfo> tests = ContainerUtil.newHashSet();

    public SuiteInfo(String url, TestStateInfo.Magnitude magnitude, Date runDate) {
        super(url, magnitude, runDate);
        this.mySuiteName = VirtualFileManager.extractPath((String)url);
    }

    public Date getMostRecentRunDate() {
        Date mostRecent = this.getRunDate();
        for (TestInfo test : this.tests) {
            Date testDate = test.getRunDate();
            if (testDate.compareTo(mostRecent) <= 0) continue;
            mostRecent = testDate;
        }
        return mostRecent;
    }

    public boolean canTrustSuiteMagnitude() {
        Date suiteRunDate = this.getRunDate();
        for (TestInfo test : this.tests) {
            if (test.getRunDate().getTime() <= suiteRunDate.getTime()) continue;
            return false;
        }
        return true;
    }

    public boolean isPassed() {
        return this.getMagnitude() == TestStateInfo.Magnitude.IGNORED_INDEX || this.getMagnitude() == TestStateInfo.Magnitude.PASSED_INDEX || this.getMagnitude() == TestStateInfo.Magnitude.COMPLETE_INDEX;
    }

    public List<TestInfo> getFailedTests() {
        List failed = ContainerUtil.newSmartList();
        for (TestInfo test : this.tests) {
            if (test.getMagnitude() != TestStateInfo.Magnitude.FAILED_INDEX && test.getMagnitude() != TestStateInfo.Magnitude.ERROR_INDEX) continue;
            failed.add(test);
        }
        return failed;
    }

    public String getSuiteName() {
        return this.mySuiteName;
    }

    public void addTest(TestInfo info) {
        this.tests.add(info);
    }

    public int getTotalTestsCount() {
        return this.tests.size();
    }
}

