/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NonNls;

public abstract class MultilineTreeCellRenderer
extends JComponent
implements TreeCellRenderer {
    private boolean myWrapsCalculated = false;
    private boolean myTooSmall = false;
    private int myHeightCalculated = -1;
    private int myWrapsCalculatedForWidth = -1;
    private ArrayList myWraps = new ArrayList();
    private int myMinHeight = 1;
    private Insets myTextInsets;
    private final Insets myLabelInsets = new Insets(1, 2, 1, 2);
    private boolean mySelected;
    private boolean myHasFocus;
    private Icon myIcon;
    private String[] myLines = ArrayUtil.EMPTY_STRING_ARRAY;
    private String myPrefix;
    private int myTextLength;
    private int myPrefixWidth;
    @NonNls
    protected static final String FONT_PROPERTY_NAME = "font";
    private JTree myTree;
    private static final int MIN_WIDTH = 10;

    public MultilineTreeCellRenderer() {
        this.myTextInsets = new Insets(0, 0, 0, 0);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MultilineTreeCellRenderer.this.onSizeChanged();
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (MultilineTreeCellRenderer.FONT_PROPERTY_NAME.equalsIgnoreCase(evt.getPropertyName())) {
                    MultilineTreeCellRenderer.this.onFontChanged();
                }
            }
        });
    }

    protected void setMinHeight(int height) {
        this.myMinHeight = height;
        this.myHeightCalculated = Math.max(this.myMinHeight, this.myHeightCalculated);
    }

    protected void setTextInsets(Insets textInsets) {
        this.myTextInsets = textInsets;
        this.onSizeChanged();
    }

    private void onFontChanged() {
        this.myWrapsCalculated = false;
    }

    private void onSizeChanged() {
        int currWidth = this.getWidth();
        if (currWidth != this.myWrapsCalculatedForWidth) {
            this.myWrapsCalculated = false;
            this.myHeightCalculated = -1;
            this.myWrapsCalculatedForWidth = -1;
        }
    }

    private FontMetrics getCurrFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    @Override
    public void paint(Graphics g) {
        Color fgColor;
        Color bgColor;
        int height = this.getHeight();
        int width = this.getWidth();
        int borderX = this.myLabelInsets.left - 1;
        int borderY = this.myLabelInsets.top - 1;
        int borderW = width - borderX - this.myLabelInsets.right + 2;
        int borderH = height - borderY - this.myLabelInsets.bottom + 1;
        if (this.myIcon != null) {
            int verticalIconPosition = (height - this.myIcon.getIconHeight()) / 2;
            this.myIcon.paintIcon(this, g, 0, verticalIconPosition);
            borderX += this.myIcon.getIconWidth();
            borderW -= this.myIcon.getIconWidth();
        }
        if (this.mySelected && this.myHasFocus) {
            bgColor = UIUtil.getTreeSelectionBackground();
            fgColor = UIUtil.getTreeSelectionForeground();
        } else {
            bgColor = UIUtil.getTreeTextBackground();
            fgColor = this.getForeground();
        }
        if (!(this.myTree.getUI() instanceof WideSelectionTreeUI) || !((WideSelectionTreeUI)this.myTree.getUI()).isWideSelection()) {
            g.setColor(bgColor);
            g.fillRect(borderX, borderY, borderW, borderH);
            if (this.mySelected) {
                g.setColor(UIUtil.getTreeSelectionBorderColor());
                UIUtil.drawDottedRectangle((Graphics)g, (int)borderX, (int)borderY, (int)(borderX + borderW - 1), (int)(borderY + borderH - 1));
            }
        }
        this.recalculateWraps();
        if (this.myTooSmall) {
            return;
        }
        int fontHeight = this.getCurrFontMetrics().getHeight();
        int currBaseLine = this.getCurrFontMetrics().getAscent();
        currBaseLine += this.myTextInsets.top;
        g.setFont(this.getFont());
        g.setColor(fgColor);
        UISettings.setupAntialiasing((Graphics)g);
        if (!StringUtil.isEmpty((String)this.myPrefix)) {
            g.drawString(this.myPrefix, this.myTextInsets.left - this.myPrefixWidth + 1, currBaseLine);
        }
        for (int i = 0; i < this.myWraps.size(); ++i) {
            String currLine = (String)this.myWraps.get(i);
            g.drawString(currLine, this.myTextInsets.left, currBaseLine);
            currBaseLine += fontHeight;
        }
    }

    public void setText(String[] lines, String prefix) {
        this.myLines = lines;
        this.myTextLength = 0;
        for (int i = 0; i < lines.length; ++i) {
            this.myTextLength += lines[i].length();
        }
        this.myPrefix = prefix;
        this.myWrapsCalculated = false;
        this.myHeightCalculated = -1;
        this.myWrapsCalculatedForWidth = -1;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
        this.myWrapsCalculated = false;
        this.myHeightCalculated = -1;
        this.myWrapsCalculatedForWidth = -1;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.getFont() != null) {
            int minHeight = this.getCurrFontMetrics().getHeight();
            return new Dimension(minHeight, minHeight);
        }
        return new Dimension(10 + this.myTextInsets.left + this.myTextInsets.right, 10 + this.myTextInsets.top + this.myTextInsets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        this.recalculateWraps();
        return new Dimension(this.myWrapsCalculatedForWidth, this.myHeightCalculated);
    }

    private void recalculateWraps() {
        int wrapsCount;
        int currwidth = this.getWidth();
        if (this.myWrapsCalculated) {
            if (currwidth == this.myWrapsCalculatedForWidth) {
                return;
            }
            this.myWrapsCalculated = false;
        }
        boolean bl = this.myTooSmall = (wrapsCount = this.calculateWraps(currwidth)) == -1;
        if (this.myTooSmall) {
            wrapsCount = this.myTextLength;
        }
        int fontHeight = this.getCurrFontMetrics().getHeight();
        this.myHeightCalculated = wrapsCount * fontHeight + this.myTextInsets.top + this.myTextInsets.bottom;
        this.myHeightCalculated = Math.max(this.myMinHeight, this.myHeightCalculated);
        int maxWidth = 0;
        for (int i = 0; i < this.myWraps.size(); ++i) {
            String s = (String)this.myWraps.get(i);
            int width = this.getCurrFontMetrics().stringWidth(s);
            maxWidth = Math.max(maxWidth, width);
        }
        this.myWrapsCalculatedForWidth = this.myTextInsets.left + maxWidth + this.myTextInsets.right;
        this.myWrapsCalculated = true;
    }

    private int calculateWraps(int width) {
        boolean bl = this.myTooSmall = width < 10;
        if (this.myTooSmall) {
            return -1;
        }
        int result = 0;
        this.myWraps = new ArrayList();
        for (int i = 0; i < this.myLines.length; ++i) {
            String aLine = this.myLines[i];
            int lineFirstChar = 0;
            int lineLastChar = aLine.length() - 1;
            int currFirst = lineFirstChar;
            int printableWidth = width - this.myTextInsets.left - this.myTextInsets.right;
            if (aLine.length() == 0) {
                this.myWraps.add(aLine);
                ++result;
                continue;
            }
            while (currFirst <= lineLastChar) {
                int currChar;
                int currLast = this.calculateLastVisibleChar(aLine, printableWidth, currFirst, lineLastChar);
                if (currLast < lineLastChar && !Character.isWhitespace(aLine.charAt(currChar = currLast + 1))) {
                    while (currChar >= currFirst && !Character.isWhitespace(aLine.charAt(currChar))) {
                        --currChar;
                    }
                    if (currChar > currFirst) {
                        currLast = currChar;
                    }
                }
                this.myWraps.add(aLine.substring(currFirst, currLast + 1));
                for (currFirst = currLast + 1; currFirst <= lineLastChar && Character.isWhitespace(aLine.charAt(currFirst)); ++currFirst) {
                }
                ++result;
            }
        }
        return result;
    }

    private int calculateLastVisibleChar(String line, int viewWidth, int firstChar, int lastChar) {
        if (firstChar == lastChar) {
            return lastChar;
        }
        if (firstChar > lastChar) {
            throw new IllegalArgumentException("firstChar=" + firstChar + ", lastChar=" + lastChar);
        }
        int totalWidth = this.getCurrFontMetrics().stringWidth(line.substring(firstChar, lastChar + 1));
        if (totalWidth == 0 || viewWidth > totalWidth) {
            return lastChar;
        }
        int newApprox = (lastChar - firstChar + 1) * viewWidth / totalWidth;
        int currChar = firstChar + Math.max(newApprox - 1, 0);
        int currWidth = this.getCurrFontMetrics().stringWidth(line.substring(firstChar, currChar + 1));
        while (true) {
            if (currWidth > viewWidth) {
                if (--currChar <= firstChar) {
                    return firstChar;
                }
                if ((currWidth -= this.getCurrFontMetrics().charWidth(line.charAt(currChar + 1))) > viewWidth) continue;
                return currChar;
            }
            if (++currChar > lastChar) {
                return lastChar;
            }
            if ((currWidth += this.getCurrFontMetrics().charWidth(line.charAt(currChar))) >= viewWidth) break;
        }
        return currChar - 1;
    }

    private int getChildIndent(JTree tree) {
        TreeUI newUI = tree.getUI();
        if (newUI instanceof BasicTreeUI) {
            BasicTreeUI btreeui = (BasicTreeUI)newUI;
            return btreeui.getLeftChildIndent() + btreeui.getRightChildIndent();
        }
        return Integer.valueOf(UIUtil.getTreeLeftChildIndent()) + Integer.valueOf(UIUtil.getTreeRightChildIndent());
    }

    private int getAvailableWidth(Object forValue, JTree tree) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)forValue;
        int busyRoom = tree.getInsets().left + tree.getInsets().right + this.getChildIndent(tree) * node.getLevel();
        return tree.getVisibleRect().width - busyRoom - 2;
    }

    protected abstract void initComponent(JTree var1, Object var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setFont(UIUtil.getTreeFont());
        this.initComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.mySelected = selected;
        this.myHasFocus = hasFocus;
        this.myTree = tree;
        int availWidth = this.getAvailableWidth(value, tree);
        if (availWidth > 0) {
            this.setSize(availWidth, 100);
        }
        int leftInset = this.myLabelInsets.left;
        if (this.myIcon != null) {
            leftInset += this.myIcon.getIconWidth() + 2;
        }
        if (!StringUtil.isEmpty((String)this.myPrefix)) {
            this.myPrefixWidth = this.getCurrFontMetrics().stringWidth(this.myPrefix) + 5;
            leftInset += this.myPrefixWidth;
        }
        this.setTextInsets(new Insets(this.myLabelInsets.top, leftInset, this.myLabelInsets.bottom, this.myLabelInsets.right));
        if (this.myIcon != null) {
            this.setMinHeight(this.myIcon.getIconHeight());
        } else {
            this.setMinHeight(1);
        }
        this.setSize(this.getPreferredSize());
        this.recalculateWraps();
        return this;
    }

    public static JScrollPane installRenderer(final JTree tree, final MultilineTreeCellRenderer renderer) {
        final TreeCellRenderer defaultRenderer = tree.getCellRenderer();
        JBScrollPane scrollpane = new JBScrollPane(tree){
            private int myAddRemoveCounter;
            private boolean myShouldResetCaches;
            {
                super(x0);
                this.myAddRemoveCounter = 0;
                this.myShouldResetCaches = false;
            }

            public void setSize(Dimension d) {
                boolean isChanged = this.getWidth() != d.width || this.myShouldResetCaches;
                super.setSize(d);
                if (isChanged) {
                    this.resetCaches();
                }
            }

            public void reshape(int x, int y, int w, int h) {
                boolean isChanged = w != this.getWidth() || this.myShouldResetCaches;
                super.reshape(x, y, w, h);
                if (isChanged) {
                    this.resetCaches();
                }
            }

            private void resetCaches() {
                MultilineTreeCellRenderer.resetHeightCache(tree, defaultRenderer, renderer);
                this.myShouldResetCaches = false;
            }

            public void addNotify() {
                super.addNotify();
                if (this.myAddRemoveCounter == 0) {
                    this.myShouldResetCaches = true;
                }
                ++this.myAddRemoveCounter;
            }

            public void removeNotify() {
                super.removeNotify();
                --this.myAddRemoveCounter;
            }
        };
        scrollpane.setHorizontalScrollBarPolicy(32);
        scrollpane.setVerticalScrollBarPolicy(22);
        tree.setCellRenderer(renderer);
        scrollpane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MultilineTreeCellRenderer.resetHeightCache(tree, defaultRenderer, renderer);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                MultilineTreeCellRenderer.resetHeightCache(tree, defaultRenderer, renderer);
            }
        });
        return scrollpane;
    }

    private static void resetHeightCache(JTree tree, TreeCellRenderer defaultRenderer, MultilineTreeCellRenderer renderer) {
        tree.setCellRenderer(defaultRenderer);
        tree.setCellRenderer(renderer);
    }
}

