/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.unscramble.UnscrambleDialog;
import com.intellij.unscramble.UnscrambleListener;
import com.intellij.util.messages.MessageBusConnection;

public final class UnscrambleAction
extends AnAction
implements DumbAware {
    private static final UnscrambleListener LISTENER = new UnscrambleListener();
    private static MessageBusConnection ourConnection;

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        new UnscrambleDialog(project2).show();
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(event.getDataContext());
        presentation.setEnabled(project2 != null);
    }

    static {
        String key = "analyze.exceptions.on.the.fly";
        final ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        if (Registry.is((String)"analyze.exceptions.on.the.fly")) {
            ourConnection = app.getMessageBus().connect();
            ourConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)LISTENER);
        }
        Registry.get((String)"analyze.exceptions.on.the.fly").addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

            public void afterValueChanged(RegistryValue value) {
                if (value.asBoolean()) {
                    ourConnection = app.getMessageBus().connect();
                    ourConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)LISTENER);
                } else {
                    ourConnection.disconnect();
                }
            }
        }, (Disposable)app);
    }
}

