/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.reference.SoftReference;
import com.intellij.util.JdomKt;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.Reference;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.ConstantsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.EntityResolver;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\u001a\b\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\u000e\u001a\u00020\u000f\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"cachedSaxBuilder", "Ljava/lang/ThreadLocal;", "Lcom/intellij/reference/SoftReference;", "Lorg/jdom/input/SAXBuilder;", "getSaxBuilder", "loadDocument", "Lorg/jdom/Document;", "reader", "Ljava/io/Reader;", "loadElement", "Lorg/jdom/Element;", "kotlin.jvm.PlatformType", "path", "Ljava/nio/file/Path;", "chars", "", "platform-impl"})
public final class JdomKt {
    private static final ThreadLocal<SoftReference<SAXBuilder>> cachedSaxBuilder = new ThreadLocal();

    private static final SAXBuilder getSaxBuilder() {
        SoftReference<SAXBuilder> reference = cachedSaxBuilder.get();
        SAXBuilder saxBuilder = (SAXBuilder)SoftReference.dereference((Reference)((Reference)reference));
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
            saxBuilder.setIgnoringBoundaryWhitespace(true);
            saxBuilder.setIgnoringElementContentWhitespace(true);
            saxBuilder.setEntityResolver((EntityResolver)getSaxBuilder.1.INSTANCE);
            cachedSaxBuilder.set((SoftReference<SAXBuilder>)new SoftReference((Object)saxBuilder));
        }
        return saxBuilder;
    }

    public static final Element loadElement(@NotNull CharSequence chars) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        return JdomKt.loadDocument((Reader)new CharSequenceReader(chars)).detachRootElement();
    }

    public static final Element loadElement(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        Charset charset = null;
        boolean bl = true;
        Object var4_5 = null;
        if (var4_5 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bufferedReader");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        InputStream $receiver$iv$iv = inputStream;
        Reader reader = new InputStreamReader($receiver$iv$iv, charset);
        int n = 0;
        boolean bl2 = true;
        Object var6_8 = null;
        if (var6_8 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl2 & true) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        return JdomKt.loadDocument(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).detachRootElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Document loadDocument(Reader reader) {
        block6: {
            block5: {
                if (Registry.is((String)"jdom.ignoring.whitespace", (boolean)false)) break block5;
                Application application = ApplicationManager.getApplication();
                if (!(application != null ? application.isUnitTestMode() : false)) break block6;
            }
            try {
                Document document = JdomKt.getSaxBuilder().build(reader);
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"getSaxBuilder().build(reader)");
                Document document2 = document;
                return document2;
            }
            finally {
                reader.close();
            }
        }
        Document document = JDOMUtil.loadDocument((Reader)reader);
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"JDOMUtil.loadDocument(reader)");
        return document;
    }
}

