/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class IndexedFilesListener
extends VirtualFileAdapter
implements BulkFileListener {
    IndexedFilesListener() {
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/IndexedFilesListener", "fileMoved"));
        }
        this.buildIndicesForFileRecursively(event.getFile(), false);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/IndexedFilesListener", "fileCreated"));
        }
        this.buildIndicesForFileRecursively(event.getFile(), false);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/IndexedFilesListener", "fileCopied"));
        }
        this.buildIndicesForFileRecursively(event.getFile(), false);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/IndexedFilesListener", "beforeFileDeletion"));
        }
        this.invalidateIndicesRecursively(event.getFile(), false);
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/IndexedFilesListener", "beforeContentsChange"));
        }
        this.invalidateIndicesRecursively(event.getFile(), true);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/IndexedFilesListener", "contentsChanged"));
        }
        this.buildIndicesForFileRecursively(event.getFile(), true);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/IndexedFilesListener", "beforePropertyChange"));
        }
        String propertyName = event.getPropertyName();
        if (propertyName.equals("name")) {
            this.invalidateIndicesRecursively(event.getFile(), false);
        } else if (propertyName.equals("encoding")) {
            this.invalidateIndicesRecursively(event.getFile(), true);
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/IndexedFilesListener", "propertyChanged"));
        }
        String propertyName = event.getPropertyName();
        if (propertyName.equals("name")) {
            this.buildIndicesForFileRecursively(event.getFile(), false);
        } else if (propertyName.equals("encoding")) {
            this.buildIndicesForFileRecursively(event.getFile(), true);
        }
    }

    protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, final boolean contentChange) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/IndexedFilesListener", "buildIndicesForFileRecursively"));
        }
        if (file2.isDirectory()) {
            ContentIterator iterator = new ContentIterator(){

                public boolean processFile(@NotNull VirtualFile fileOrDir) {
                    if (fileOrDir == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/util/indexing/IndexedFilesListener$1", "processFile"));
                    }
                    IndexedFilesListener.this.buildIndicesForFile(fileOrDir, contentChange);
                    return true;
                }
            };
            this.iterateIndexableFiles(file2, iterator);
        } else {
            this.buildIndicesForFile(file2, contentChange);
        }
    }

    protected abstract void iterateIndexableFiles(VirtualFile var1, ContentIterator var2);

    protected abstract void buildIndicesForFile(VirtualFile var1, boolean var2);

    protected abstract boolean invalidateIndicesForFile(VirtualFile var1, boolean var2);

    protected void invalidateIndicesRecursively(@NotNull VirtualFile file2, final boolean contentChange) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/IndexedFilesListener", "invalidateIndicesRecursively"));
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/IndexedFilesListener$2", "visitFile"));
                }
                return IndexedFilesListener.this.invalidateIndicesForFile(file2, contentChange);
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/IndexedFilesListener$2", "getChildrenIterable"));
                }
                return file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).iterInDbChildren() : null;
            }
        });
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/indexing/IndexedFilesListener", "before"));
        }
        for (VFileEvent vFileEvent : events) {
            BulkVirtualFileListenerAdapter.fireBefore((VirtualFileListener)this, (VFileEvent)vFileEvent);
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/indexing/IndexedFilesListener", "after"));
        }
        for (VFileEvent vFileEvent : events) {
            BulkVirtualFileListenerAdapter.fireAfter((VirtualFileListener)this, (VFileEvent)vFileEvent);
        }
    }
}

