/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.highlighting.DomCollectionProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptorImpl;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementAnnotationHolderImpl
extends SmartList<DomElementProblemDescriptor>
implements DomElementAnnotationHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl");
    private final SmartList<Annotation> myAnnotations = new SmartList();
    private final boolean myOnTheFly;

    public DomElementAnnotationHolderImpl(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @NotNull
    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, @Nullable String message, LocalQuickFix ... fixes) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createProblem"));
        }
        DomElementProblemDescriptor domElementProblemDescriptor = this.createProblem(domElement, HighlightSeverity.ERROR, message, fixes);
        if (domElementProblemDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createProblem"));
        }
        return domElementProblemDescriptor;
    }

    @NotNull
    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, DomCollectionChildDescription childDescription, @Nullable String message) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createProblem"));
        }
        DomCollectionProblemDescriptorImpl domCollectionProblemDescriptorImpl = this.addProblem(new DomCollectionProblemDescriptorImpl(domElement, message, HighlightSeverity.ERROR, childDescription));
        if (domCollectionProblemDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createProblem"));
        }
        return domCollectionProblemDescriptorImpl;
    }

    @NotNull
    public final DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, String message) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createProblem"));
        }
        DomElementProblemDescriptor domElementProblemDescriptor = this.createProblem(domElement, highlightType, message, LocalQuickFix.EMPTY_ARRAY);
        if (domElementProblemDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createProblem"));
        }
        return domElementProblemDescriptor;
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, String message, LocalQuickFix[] fixes) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createProblem"));
        }
        return this.createProblem(domElement, highlightType, message, null, fixes);
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, String message, TextRange textRange, LocalQuickFix ... fixes) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createProblem"));
        }
        return this.addProblem(new DomElementProblemDescriptorImpl(domElement, message, highlightType, textRange, null, fixes));
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, ProblemHighlightType highlightType, String message, @Nullable TextRange textRange, LocalQuickFix ... fixes) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createProblem"));
        }
        return this.addProblem(new DomElementProblemDescriptorImpl(domElement, message, HighlightSeverity.ERROR, textRange, highlightType, fixes));
    }

    @NotNull
    public DomElementResolveProblemDescriptor createResolveProblem(@NotNull GenericDomValue element, @NotNull PsiReference reference) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createResolveProblem"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createResolveProblem"));
        }
        DomElementResolveProblemDescriptor domElementResolveProblemDescriptor = this.addProblem(new DomElementResolveProblemDescriptorImpl(element, reference, this.getQuickFixes(element, reference)));
        if (domElementResolveProblemDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createResolveProblem"));
        }
        return domElementResolveProblemDescriptor;
    }

    @NotNull
    public Annotation createAnnotation(@NotNull DomElement element, HighlightSeverity severity, @Nullable String message) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createAnnotation"));
        }
        XmlElement xmlElement = element.getXmlElement();
        LOG.assertTrue(xmlElement != null, (Object)("No XML element for " + element));
        TextRange range = xmlElement.getTextRange();
        int startOffset = range.getStartOffset();
        int endOffset = message == null ? startOffset : range.getEndOffset();
        Annotation annotation = new Annotation(startOffset, endOffset, severity, message, null);
        this.myAnnotations.add((Object)annotation);
        Annotation annotation2 = annotation;
        if (annotation2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl", "createAnnotation"));
        }
        return annotation2;
    }

    public final SmartList<Annotation> getAnnotations() {
        return this.myAnnotations;
    }

    public int getSize() {
        return this.size();
    }

    private LocalQuickFix[] getQuickFixes(GenericDomValue element, PsiReference reference) {
        Object[] localQuickFixes;
        if (!this.myOnTheFly) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        SmartList result = new SmartList();
        Converter converter = WrappingConverter.getDeepestConverter((Converter)element.getConverter(), (GenericDomValue)element);
        if (converter instanceof ResolvingConverter) {
            ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
            ContainerUtil.addAll((Collection)result, (Object[])resolvingConverter.getQuickFixes(ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler((DomElement)element))));
        }
        if (reference instanceof LocalQuickFixProvider && (localQuickFixes = ((LocalQuickFixProvider)reference).getQuickFixes()) != null) {
            ContainerUtil.addAll((Collection)result, (Object[])localQuickFixes);
        }
        return result.isEmpty() ? LocalQuickFix.EMPTY_ARRAY : result.toArray(new LocalQuickFix[result.size()]);
    }

    public <T extends DomElementProblemDescriptor> T addProblem(T problemDescriptor) {
        this.add(problemDescriptor);
        return problemDescriptor;
    }
}

