/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.PropertyAccessor;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AddChildInvocation;
import com.intellij.util.xml.impl.AddToCompositeCollectionInvocation;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.ChildrenDescriptionsHolder;
import com.intellij.util.xml.impl.CollectionChildDescriptionImpl;
import com.intellij.util.xml.impl.CustomDomChildrenDescriptionImpl;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.GetAttributeChildInvocation;
import com.intellij.util.xml.impl.GetCollectionChildInvocation;
import com.intellij.util.xml.impl.GetCompositeCollectionInvocation;
import com.intellij.util.xml.impl.GetFixedChildInvocation;
import com.intellij.util.xml.impl.Invocation;
import com.intellij.util.xml.impl.PropertyAccessorInvocation;
import com.intellij.util.xml.impl.StaticGenericInfoBuilder;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import gnu.trove.THashMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticGenericInfo
extends DomGenericInfoEx {
    private final Class myClass;
    private final ChildrenDescriptionsHolder<AttributeChildDescriptionImpl> myAttributes = new ChildrenDescriptionsHolder();
    private final ChildrenDescriptionsHolder<FixedChildDescriptionImpl> myFixed = new ChildrenDescriptionsHolder();
    private final ChildrenDescriptionsHolder<CollectionChildDescriptionImpl> myCollections = new ChildrenDescriptionsHolder();
    private Map<JavaMethodSignature, Pair<FixedChildDescriptionImpl, Integer>> myFixedChildrenMethods;
    private Map<JavaMethodSignature, CollectionChildDescriptionImpl> myCollectionChildrenGetterMethods;
    private final Map<JavaMethodSignature, CollectionChildDescriptionImpl> myCollectionChildrenAdditionMethods = new THashMap();
    private Map<JavaMethodSignature, AttributeChildDescriptionImpl> myAttributeChildrenMethods;
    private final Map<JavaMethodSignature, Set<CollectionChildDescriptionImpl>> myCompositeChildrenMethods = new THashMap();
    private final Map<JavaMethodSignature, Pair<CollectionChildDescriptionImpl, Set<CollectionChildDescriptionImpl>>> myCompositeCollectionAdditionMethods = new THashMap();
    @Nullable
    private JavaMethod myNameValueGetter;
    private boolean myValueElement;
    private boolean myInitialized;
    private CustomDomChildrenDescriptionImpl myCustomDescription;

    public StaticGenericInfo(Class clazz) {
        this.myClass = clazz;
    }

    public final synchronized boolean buildMethodMaps() {
        if (!this.myInitialized) {
            StaticGenericInfoBuilder builder = new StaticGenericInfoBuilder(this.myClass);
            JavaMethod customChildrenGetter = builder.getCustomChildrenGetter();
            if (customChildrenGetter != null) {
                this.myCustomDescription = new CustomDomChildrenDescriptionImpl(customChildrenGetter);
            }
            this.myAttributeChildrenMethods = builder.getAttributes();
            this.myAttributes.addDescriptions(this.myAttributeChildrenMethods.values());
            this.myFixedChildrenMethods = builder.getFixedGetters();
            for (Pair<FixedChildDescriptionImpl, Integer> pair : this.myFixedChildrenMethods.values()) {
                this.myFixed.addDescription((FixedChildDescriptionImpl)((DomChildDescriptionImpl)pair.first));
            }
            this.myCollectionChildrenGetterMethods = builder.getCollectionGetters();
            this.myCollections.addDescriptions(this.myCollectionChildrenGetterMethods.values());
            for (CollectionChildDescriptionImpl description : this.myCollectionChildrenGetterMethods.values()) {
                XmlName name = description.getXmlName();
                this.addAdders(description, builder.collectionAdders.get((Object)name));
                this.addAdders(description, builder.collectionIndexAdders.get((Object)name));
                this.addAdders(description, builder.collectionIndexClassAdders.get((Object)name));
                this.addAdders(description, builder.collectionClassIndexAdders.get((Object)name));
                this.addAdders(description, builder.collectionClassAdders.get((Object)name));
            }
            NotNullFunction<String, CollectionChildDescriptionImpl> mapper = new NotNullFunction<String, CollectionChildDescriptionImpl>(){

                @NotNull
                public CollectionChildDescriptionImpl fun(String xmlName) {
                    CollectionChildDescriptionImpl collectionChildDescriptionImpl = (CollectionChildDescriptionImpl)ObjectUtils.assertNotNull(StaticGenericInfo.this.myCollections.findDescription(xmlName));
                    if (collectionChildDescriptionImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/StaticGenericInfo$1", "fun"));
                    }
                    return collectionChildDescriptionImpl;
                }
            };
            Map<JavaMethodSignature, String[]> getters = builder.getCompositeCollectionGetters();
            for (JavaMethodSignature signature : getters.keySet()) {
                this.myCompositeChildrenMethods.put(signature, ContainerUtil.map2Set((Object[])getters.get(signature), (Function)mapper));
            }
            Map<JavaMethodSignature, Pair<String, String[]>> adders = builder.getCompositeCollectionAdders();
            for (JavaMethodSignature signature : adders.keySet()) {
                Pair<String, String[]> pair = adders.get(signature);
                this.myCompositeCollectionAdditionMethods.put(signature, (Pair<CollectionChildDescriptionImpl, Set<CollectionChildDescriptionImpl>>)Pair.create((Object)this.myCollections.findDescription((String)pair.first), (Object)ContainerUtil.map2Set((Object[])((Object[])pair.second), (Function)mapper)));
            }
            this.myNameValueGetter = builder.getNameValueGetter();
            this.myValueElement = builder.isValueElement();
            this.myInitialized = true;
        }
        return true;
    }

    private void addAdders(CollectionChildDescriptionImpl description, Collection<JavaMethod> methods) {
        if (methods != null) {
            for (JavaMethod method : methods) {
                this.myCollectionChildrenAdditionMethods.put(method.getSignature(), description);
            }
        }
    }

    @Override
    public boolean checkInitialized() {
        return this.buildMethodMaps();
    }

    @Override
    public final Invocation createInvocation(JavaMethod method) {
        this.buildMethodMaps();
        JavaMethodSignature signature = method.getSignature();
        PropertyAccessor accessor = (PropertyAccessor)method.getAnnotation(PropertyAccessor.class);
        if (accessor != null) {
            return new PropertyAccessorInvocation(DomReflectionUtil.getGetterMethods((String[])accessor.value(), (Class)this.myClass));
        }
        if (this.myAttributeChildrenMethods.containsKey(signature)) {
            return new GetAttributeChildInvocation(this.myAttributeChildrenMethods.get(signature));
        }
        if (this.myFixedChildrenMethods.containsKey(signature)) {
            return new GetFixedChildInvocation(this.myFixedChildrenMethods.get(signature));
        }
        Set<CollectionChildDescriptionImpl> qnames = this.myCompositeChildrenMethods.get(signature);
        if (qnames != null) {
            return new GetCompositeCollectionInvocation(qnames);
        }
        if (this.myCustomDescription != null && method.equals((Object)this.myCustomDescription.getGetterMethod())) {
            return new Invocation(){

                @Override
                @Nullable
                public Object invoke(DomInvocationHandler<?, ?> handler2, Object[] args) throws Throwable {
                    return StaticGenericInfo.this.myCustomDescription.getValues(handler2);
                }
            };
        }
        Pair<CollectionChildDescriptionImpl, Set<CollectionChildDescriptionImpl>> pair = this.myCompositeCollectionAdditionMethods.get(signature);
        if (pair != null) {
            return new AddToCompositeCollectionInvocation((CollectionChildDescriptionImpl)pair.first, (Set)pair.second, method.getGenericReturnType());
        }
        CollectionChildDescriptionImpl description = this.myCollectionChildrenGetterMethods.get(signature);
        if (description != null) {
            return new GetCollectionChildInvocation(description);
        }
        description = this.myCollectionChildrenAdditionMethods.get(signature);
        if (description != null) {
            return new AddChildInvocation(StaticGenericInfo.getTypeGetter(method), StaticGenericInfo.getIndexGetter(method), description, description.getType());
        }
        return null;
    }

    private static Function<Object[], Type> getTypeGetter(final JavaMethod method) {
        Class[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length >= 1 && parameterTypes[0].equals(Class.class)) {
            return new Function.First();
        }
        if (parameterTypes.length == 2 && parameterTypes[1].equals(Class.class)) {
            return new Function<Object[], Type>(){

                public Type fun(Object[] s) {
                    return (Type)s[1];
                }
            };
        }
        return new Function<Object[], Type>(){

            public Type fun(Object[] s) {
                return method.getGenericReturnType();
            }
        };
    }

    private static Function<Object[], Integer> getIndexGetter(JavaMethod method) {
        Class[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length >= 1 && parameterTypes[0].equals(Integer.TYPE)) {
            return new Function.First();
        }
        if (parameterTypes.length == 2 && parameterTypes[1].equals(Integer.TYPE)) {
            return new Function<Object[], Integer>(){

                public Integer fun(Object[] s) {
                    return (Integer)s[1];
                }
            };
        }
        return new ConstantFunction((Object)Integer.MAX_VALUE);
    }

    @Nullable
    public XmlElement getNameElement(DomElement element) {
        this.buildMethodMaps();
        Object o = this.getNameObject(element);
        if (o instanceof GenericAttributeValue) {
            return ((GenericAttributeValue)o).getXmlAttributeValue();
        }
        if (o instanceof DomElement) {
            return ((DomElement)o).getXmlTag();
        }
        return null;
    }

    @Nullable
    public GenericDomValue getNameDomElement(DomElement element) {
        this.buildMethodMaps();
        Object o = this.getNameObject(element);
        return o instanceof GenericDomValue ? (GenericDomValue)o : null;
    }

    @NotNull
    public List<? extends CustomDomChildrenDescriptionImpl> getCustomNameChildrenDescription() {
        List<Object> list = this.myCustomDescription == null ? Collections.emptyList() : Collections.singletonList(this.myCustomDescription);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/StaticGenericInfo", "getCustomNameChildrenDescription"));
        }
        return list;
    }

    @Nullable
    private Object getNameObject(DomElement element) {
        return this.myNameValueGetter == null ? null : this.myNameValueGetter.invoke((Object)element, new Object[0]);
    }

    @Nullable
    public String getElementName(DomElement element) {
        this.buildMethodMaps();
        Object o = this.getNameObject(element);
        return o == null || o instanceof String ? (String)o : ((GenericValue)o).getStringValue();
    }

    @NotNull
    public List<AbstractDomChildDescriptionImpl> getChildrenDescriptions() {
        this.buildMethodMaps();
        ArrayList<AbstractDomChildDescriptionImpl> list = new ArrayList<AbstractDomChildDescriptionImpl>();
        this.myAttributes.dumpDescriptions(list);
        this.myFixed.dumpDescriptions(list);
        this.myCollections.dumpDescriptions(list);
        list.addAll(this.getCustomNameChildrenDescription());
        ArrayList<AbstractDomChildDescriptionImpl> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/StaticGenericInfo", "getChildrenDescriptions"));
        }
        return arrayList;
    }

    @NotNull
    public List<? extends DomFixedChildDescription> getFixedChildrenDescriptions() {
        this.buildMethodMaps();
        List<FixedChildDescriptionImpl> list = this.myFixed.getDescriptions();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/StaticGenericInfo", "getFixedChildrenDescriptions"));
        }
        return list;
    }

    @NotNull
    public List<? extends DomCollectionChildDescription> getCollectionChildrenDescriptions() {
        this.buildMethodMaps();
        List<CollectionChildDescriptionImpl> list = this.myCollections.getDescriptions();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/StaticGenericInfo", "getCollectionChildrenDescriptions"));
        }
        return list;
    }

    public boolean isTagValueElement() {
        this.buildMethodMaps();
        return this.myValueElement;
    }

    @Override
    @NotNull
    public List<AttributeChildDescriptionImpl> getAttributeChildrenDescriptions() {
        this.buildMethodMaps();
        ArrayList<AttributeChildDescriptionImpl> arrayList = new ArrayList<AttributeChildDescriptionImpl>(this.myAttributeChildrenMethods.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/StaticGenericInfo", "getAttributeChildrenDescriptions"));
        }
        return arrayList;
    }

    @Override
    public boolean processAttributeChildrenDescriptions(Processor<AttributeChildDescriptionImpl> processor2) {
        List<AttributeChildDescriptionImpl> descriptions = this.getAttributeChildrenDescriptions();
        return ContainerUtil.process(descriptions, processor2);
    }

    @Nullable
    public DomFixedChildDescription getFixedChildDescription(@NonNls String tagName) {
        this.buildMethodMaps();
        return this.myFixed.findDescription(tagName);
    }

    @Nullable
    public DomFixedChildDescription getFixedChildDescription(@NonNls String tagName, @NonNls String namespaceKey) {
        this.buildMethodMaps();
        return this.myFixed.getDescription(tagName, namespaceKey);
    }

    @Nullable
    public DomCollectionChildDescription getCollectionChildDescription(@NonNls String tagName) {
        this.buildMethodMaps();
        return this.myCollections.findDescription(tagName);
    }

    @Nullable
    public DomCollectionChildDescription getCollectionChildDescription(@NonNls String tagName, @NonNls String namespaceKey) {
        this.buildMethodMaps();
        return this.myCollections.getDescription(tagName, namespaceKey);
    }

    @Nullable
    public DomAttributeChildDescription getAttributeChildDescription(@NonNls String attributeName) {
        this.buildMethodMaps();
        return this.myAttributes.findDescription(attributeName);
    }

    @Nullable
    public DomAttributeChildDescription getAttributeChildDescription(@NonNls String attributeName, @NonNls String namespaceKey) {
        this.buildMethodMaps();
        return this.myAttributes.getDescription(attributeName, namespaceKey);
    }

    public ChildrenDescriptionsHolder<AttributeChildDescriptionImpl> getAttributes() {
        return this.myAttributes;
    }

    public ChildrenDescriptionsHolder<CollectionChildDescriptionImpl> getCollections() {
        return this.myCollections;
    }

    public ChildrenDescriptionsHolder<FixedChildDescriptionImpl> getFixed() {
        return this.myFixed;
    }
}

