/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.LongRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import com.intellij.openapi.vcs.versionBrowser.VcsRevisionNumberAware;
import java.util.Collection;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class CommittedChangeListForRevision
extends CommittedChangeListImpl
implements VcsRevisionNumberAware {
    @NotNull
    private VcsRevisionNumber myRevisionNumber;

    public CommittedChangeListForRevision(@NotNull String subject, @NotNull String comment, @NotNull String committerName, @NotNull Date commitDate, @NotNull Collection<Change> changes, @NotNull VcsRevisionNumber revisionNumber) {
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "com/intellij/vcs/CommittedChangeListForRevision", "<init>"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/vcs/CommittedChangeListForRevision", "<init>"));
        }
        if (committerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "committerName", "com/intellij/vcs/CommittedChangeListForRevision", "<init>"));
        }
        if (commitDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitDate", "com/intellij/vcs/CommittedChangeListForRevision", "<init>"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/vcs/CommittedChangeListForRevision", "<init>"));
        }
        if (revisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionNumber", "com/intellij/vcs/CommittedChangeListForRevision", "<init>"));
        }
        super(subject, comment, committerName, CommittedChangeListForRevision.getLong(revisionNumber), commitDate, changes);
        this.myRevisionNumber = revisionNumber;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = this.myRevisionNumber;
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/CommittedChangeListForRevision", "getRevisionNumber"));
        }
        return vcsRevisionNumber;
    }

    private static long getLong(@NotNull VcsRevisionNumber number) {
        if (number == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number", "com/intellij/vcs/CommittedChangeListForRevision", "getLong"));
        }
        if (number instanceof LongRevisionNumber) {
            return ((LongRevisionNumber)number).getLongRevisionNumber();
        }
        return 0L;
    }
}

