/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RefsModel
implements VcsLogRefs {
    @NotNull
    private final Map<VirtualFile, Set<VcsRef>> myRefs;
    @NotNull
    private final VcsLogHashMap myHashMap;
    @NotNull
    private final Collection<VcsRef> myBranches;
    @NotNull
    private final MultiMap<CommitId, VcsRef> myRefsToHashes;
    @NotNull
    private final TIntObjectHashMap<SmartList<VcsRef>> myRefsToIndices;

    public RefsModel(@NotNull Map<VirtualFile, Set<VcsRef>> refsByRoot, @NotNull VcsLogHashMap hashMap) {
        if (refsByRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsByRoot", "com/intellij/vcs/log/data/RefsModel", "<init>"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/RefsModel", "<init>"));
        }
        this.myRefs = refsByRoot;
        this.myHashMap = hashMap;
        List allRefs = ContainerUtil.concat(refsByRoot.values());
        this.myBranches = ContainerUtil.filter((Collection)allRefs, (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                return ref.getType().isBranch();
            }
        });
        this.myRefsToHashes = RefsModel.prepareRefsMap(allRefs);
        this.myRefsToIndices = this.prepareRefsToIndicesMap(allRefs);
    }

    @NotNull
    private TIntObjectHashMap<SmartList<VcsRef>> prepareRefsToIndicesMap(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/RefsModel", "prepareRefsToIndicesMap"));
        }
        TIntObjectHashMap map = new TIntObjectHashMap();
        for (VcsRef ref : refs) {
            int index = this.myHashMap.getCommitIndex(ref.getCommitHash(), ref.getRoot());
            SmartList list = (SmartList)map.get(index);
            if (list == null) {
                list = new SmartList();
                map.put(index, (Object)list);
            }
            list.add((Object)ref);
        }
        TIntObjectHashMap tIntObjectHashMap = map;
        if (tIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "prepareRefsToIndicesMap"));
        }
        return tIntObjectHashMap;
    }

    @NotNull
    private static MultiMap<CommitId, VcsRef> prepareRefsMap(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/RefsModel", "prepareRefsMap"));
        }
        MultiMap map = MultiMap.createSmart();
        for (VcsRef ref : refs) {
            map.putValue((Object)new CommitId(ref.getCommitHash(), ref.getRoot()), (Object)ref);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "prepareRefsMap"));
        }
        return multiMap;
    }

    @NotNull
    public Collection<VcsRef> refsToCommit(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
        }
        CommitId commitId = new CommitId(hash, root);
        if (this.myRefsToHashes.containsKey((Object)commitId)) {
            Collection collection = this.myRefsToHashes.get((Object)commitId);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
            }
            return collection;
        }
        List<VcsRef> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
        }
        return list;
    }

    @NotNull
    public Collection<VcsRef> refsToCommit(int index) {
        Collection<Object> collection = this.myRefsToIndices.containsKey(index) ? (Collection)this.myRefsToIndices.get(index) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
        }
        return collection;
    }

    @NotNull
    public Collection<VcsRef> getBranches() {
        Collection<VcsRef> collection = this.myBranches;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "getBranches"));
        }
        return collection;
    }

    @NotNull
    public Collection<VcsRef> getAllRefs() {
        ArrayList<VcsRef> arrayList = new ArrayList<VcsRef>(this.myRefsToHashes.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "getAllRefs"));
        }
        return arrayList;
    }

    @NotNull
    public Map<VirtualFile, Set<VcsRef>> getAllRefsByRoot() {
        Map<VirtualFile, Set<VcsRef>> map = this.myRefs;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "getAllRefsByRoot"));
        }
        return map;
    }
}

