/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.actions.TextFieldWithProgress;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcsUtil.VcsImplUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToHashOrRefPopup {
    private static final Logger LOG = Logger.getInstance(GoToHashOrRefPopup.class);
    @NotNull
    private final TextFieldWithProgress myTextField;
    @NotNull
    private final Function<String, Future> myOnSelectedHash;
    @NotNull
    private final Function<VcsRef, Future> myOnSelectedRef;
    @NotNull
    private final JBPopup myPopup;
    @Nullable
    private Future myFuture;
    @Nullable
    private VcsRef mySelectedRef;

    public GoToHashOrRefPopup(@NotNull Project project2, @NotNull Collection<VcsRef> variants, Collection<VirtualFile> roots, @NotNull Function<String, Future> onSelectedHash, @NotNull Function<VcsRef, Future> onSelectedRef, @NotNull VcsLogColorManager colorManager, @NotNull Comparator<VcsRef> comparator2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        if (onSelectedHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelectedHash", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        if (onSelectedRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelectedRef", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        if (comparator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        this.myOnSelectedHash = onSelectedHash;
        this.myOnSelectedRef = onSelectedRef;
        this.myTextField = new TextFieldWithProgress<VcsRef>(project2, (TextFieldWithAutoCompletionListProvider)new VcsRefCompletionProvider(project2, variants, roots, colorManager, comparator2)){

            @Override
            public void onOk() {
                if (GoToHashOrRefPopup.this.myFuture == null) {
                    final Future future2 = GoToHashOrRefPopup.this.mySelectedRef == null || !GoToHashOrRefPopup.this.mySelectedRef.getName().equals(this.getText().trim()) ? (Future)GoToHashOrRefPopup.this.myOnSelectedHash.fun((Object)this.getText().trim()) : (Future)GoToHashOrRefPopup.this.myOnSelectedRef.fun((Object)GoToHashOrRefPopup.this.mySelectedRef);
                    GoToHashOrRefPopup.this.myFuture = future2;
                    this.showProgress();
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                future2.get();
                                GoToHashOrRefPopup.this.okPopup();
                            }
                            catch (CancellationException ex) {
                                GoToHashOrRefPopup.this.cancelPopup();
                            }
                            catch (InterruptedException ex) {
                                GoToHashOrRefPopup.this.cancelPopup();
                            }
                            catch (ExecutionException ex) {
                                LOG.error((Throwable)ex);
                                GoToHashOrRefPopup.this.cancelPopup();
                            }
                        }
                    });
                }
            }
        };
        this.myTextField.setAlignmentX(0.0f);
        JBLabel label = new JBLabel("Enter hash or branch/tag name:");
        label.setFont(UIUtil.getLabelFont().deriveFont(1));
        label.setAlignmentX(0.0f);
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 3);
        panel.setLayout(layout);
        panel.add((Component)label);
        panel.add(this.myTextField);
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, this.myTextField.getPreferableFocusComponent()).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).setCancelKeyEnabled(true).setRequestFocus(true).createPopup();
        this.myPopup.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void onClosed(LightweightWindowEvent event) {
                if (!event.isOk() && GoToHashOrRefPopup.this.myFuture != null) {
                    GoToHashOrRefPopup.this.myFuture.cancel(true);
                }
                GoToHashOrRefPopup.this.myFuture = null;
                GoToHashOrRefPopup.this.myTextField.hideProgress();
            }
        });
    }

    private void cancelPopup() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GoToHashOrRefPopup.this.myPopup.cancel();
            }
        });
    }

    private void okPopup() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GoToHashOrRefPopup.this.myPopup.closeOk(null);
            }
        });
    }

    public void show(@NotNull JComponent anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "show"));
        }
        this.myPopup.showInCenterOf((Component)anchor);
    }

    private class VcsRefCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<VcsRef> {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsLogColorManager myColorManager;
        @NotNull
        private final Comparator<VcsRef> myReferenceComparator;
        @NotNull
        private final Map<VirtualFile, String> myCachedRootNames;

        public VcsRefCompletionProvider(@NotNull Project project2, @NotNull Collection<VcsRef> variants, @NotNull Collection<VirtualFile> roots, @NotNull VcsLogColorManager colorManager, Comparator<VcsRef> comparator2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "<init>"));
            }
            if (variants == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "<init>"));
            }
            if (colorManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "<init>"));
            }
            if (comparator2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "<init>"));
            }
            super(variants);
            this.myCachedRootNames = ContainerUtil.newHashMap();
            this.myProject = project2;
            this.myColorManager = colorManager;
            this.myReferenceComparator = comparator2;
            for (VirtualFile root : roots) {
                String text = VcsImplUtil.getShortVcsRootName(this.myProject, root);
                this.myCachedRootNames.put(root, text);
            }
        }

        @Override
        public LookupElementBuilder createLookupBuilder(@NotNull VcsRef item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "createLookupBuilder"));
            }
            LookupElementBuilder lookupBuilder = super.createLookupBuilder(item);
            if (this.myColorManager.isMultipleRoots()) {
                lookupBuilder = lookupBuilder.withTypeText(this.getTypeText(item), (Icon)new ColorIcon(15, (Color)VcsLogGraphTable.getRootBackgroundColor(item.getRoot(), this.myColorManager)), true);
            }
            return lookupBuilder;
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull VcsRef item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "getIcon"));
            }
            return null;
        }

        @Override
        @NotNull
        protected String getLookupString(@NotNull VcsRef item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "getLookupString"));
            }
            String string = item.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "getLookupString"));
            }
            return string;
        }

        @Override
        @Nullable
        protected String getTailText(@NotNull VcsRef item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "getTailText"));
            }
            if (!this.myColorManager.isMultipleRoots()) {
                return null;
            }
            return "";
        }

        @Override
        @Nullable
        protected String getTypeText(@NotNull VcsRef item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "getTypeText"));
            }
            if (!this.myColorManager.isMultipleRoots()) {
                return null;
            }
            String text = this.myCachedRootNames.get(item.getRoot());
            if (text == null) {
                return VcsImplUtil.getShortVcsRootName(this.myProject, item.getRoot());
            }
            return text;
        }

        @Override
        public int compare(VcsRef item1, VcsRef item2) {
            return this.myReferenceComparator.compare(item1, item2);
        }

        @Override
        @Nullable
        protected InsertHandler<LookupElement> createInsertHandler(@NotNull VcsRef item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "createInsertHandler"));
            }
            return new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    GoToHashOrRefPopup.this.mySelectedRef = (VcsRef)item.getObject();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GoToHashOrRefPopup.this.myTextField.onOk();
                        }
                    });
                }
            };
        }

        @Override
        @NotNull
        public Collection<VcsRef> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            if (prefix == null) {
                List<VcsRef> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "getItems"));
                }
                return list;
            }
            ArrayList<VcsRef> items = new ArrayList<VcsRef>(this.getMatched(this.myVariants, prefix));
            Collections.sort(items, this);
            ArrayList<VcsRef> arrayList = items;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "getItems"));
            }
            return arrayList;
        }

        private List<VcsRef> getMatched(@NotNull Collection<VcsRef> refs, @NotNull String prefix) {
            if (refs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "getMatched"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "getMatched"));
            }
            final PlainPrefixMatcher prefixMatcher = new PlainPrefixMatcher(prefix);
            return ContainerUtil.filter(refs, (Condition)new Condition<VcsRef>(){

                public boolean value(VcsRef vcsRef) {
                    return prefixMatcher.prefixMatches(vcsRef.getName());
                }
            });
        }
    }
}

