/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerHistoryManager {
    public static final int MAX_RECENT_EXPRESSIONS = 10;
    private final Map<String, LinkedList<XExpression>> myRecentExpressions = new HashMap<String, LinkedList<XExpression>>();

    public static XDebuggerHistoryManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerHistoryManager", "getInstance"));
        }
        return (XDebuggerHistoryManager)ServiceManager.getService((Project)project2, XDebuggerHistoryManager.class);
    }

    public boolean addRecentExpression(@NotNull @NonNls String id, @Nullable XExpression expression) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/xdebugger/impl/XDebuggerHistoryManager", "addRecentExpression"));
        }
        if (XDebuggerUtilImpl.isEmptyExpression(expression)) {
            return false;
        }
        LinkedList<Object> list = this.myRecentExpressions.get(id);
        if (list == null) {
            list = new LinkedList();
            this.myRecentExpressions.put(id, list);
        }
        if (list.size() == 10) {
            list.removeLast();
        }
        XExpressionImpl trimmedExpression = new XExpressionImpl(expression.getExpression().trim(), expression.getLanguage(), expression.getCustomInfo(), expression.getMode());
        list.remove(trimmedExpression);
        list.addFirst(trimmedExpression);
        return true;
    }

    public List<XExpression> getRecentExpressions(@NonNls String id) {
        LinkedList<XExpression> list = this.myRecentExpressions.get(id);
        return list != null ? list : Collections.emptyList();
    }
}

