/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.grouping;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointCustomGroup;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointCustomGroupingRule<B>
extends XBreakpointGroupingRule<B, XBreakpointCustomGroup> {
    public XBreakpointCustomGroupingRule() {
        super("by-group", "Show user groups");
    }

    public int getPriority() {
        return 1200;
    }

    public boolean isAlwaysEnabled() {
        return true;
    }

    public XBreakpointCustomGroup getGroup(@NotNull B breakpoint, @NotNull Collection<XBreakpointCustomGroup> groups) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/ui/grouping/XBreakpointCustomGroupingRule", "getGroup"));
        }
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/xdebugger/impl/breakpoints/ui/grouping/XBreakpointCustomGroupingRule", "getGroup"));
        }
        if (!(breakpoint instanceof XBreakpointBase)) {
            return null;
        }
        String name = ((XBreakpointBase)breakpoint).getGroup();
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        return new XBreakpointCustomGroup(name, ((XBreakpointBase)breakpoint).getProject());
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.NewFolder;
    }
}

