/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.JsonSchemaConfigurable;
import com.jetbrains.jsonSchema.JsonSchemaMappingsConfigurationBase;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.JsonSchemaPatternComparator;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaMappingsConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable,
Disposable {
    @NonNls
    public static final String SETTINGS_JSON_SCHEMA = "settings.json.schema";
    public static final String JSON_SCHEMA_MAPPINGS = "JSON Schema";
    private static final Comparator<JsonSchemaMappingsConfigurationBase.SchemaInfo> COMPARATOR = new Comparator<JsonSchemaMappingsConfigurationBase.SchemaInfo>(){

        @Override
        public int compare(JsonSchemaMappingsConfigurationBase.SchemaInfo o1, JsonSchemaMappingsConfigurationBase.SchemaInfo o2) {
            if (o1.isApplicationLevel() != o2.isApplicationLevel()) {
                return o1.isApplicationLevel() ? -1 : 1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    public static final String READ_JSON_SCHEMA = "Read JSON Schema";
    public static final String ADD_PROJECT_SCHEMA = "Add Project Schema";
    private String myError;
    @Nullable
    private Project myProject;
    private Runnable myTreeUpdater = new Runnable(){

        @Override
        public void run() {
            JsonSchemaMappingsConfigurable.this.TREE_UPDATER.run();
            JsonSchemaMappingsConfigurable.this.updateWarningText();
        }
    };

    public JsonSchemaMappingsConfigurable(@Nullable Project project2) {
        this.myProject = project2;
        this.initTree();
        this.fillTree();
        this.updateWarningText();
    }

    @Nullable
    protected String getEmptySelectionString() {
        return this.myRoot.children().hasMoreElements() ? "Select JSON Schema to view" : "Please add a JSON Schema file and configure its usage";
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add((AnAction)new DumbAwareAction("Add", "Add", IconUtil.getAddIcon()){
            {
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)JsonSchemaMappingsConfigurable.this.myTree);
            }

            public void actionPerformed(AnActionEvent e) {
                JsonSchemaMappingsConfigurable.this.addProjectSchema();
            }
        });
        result.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return result;
    }

    private void addProjectSchema() {
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(JsonBundle.message("json.schema.add.schema.chooser.title", new Object[0])), (Project)this.myProject, null);
        if (file2 != null) {
            String relativePath = VfsUtil.getRelativePath((VirtualFile)file2, (VirtualFile)this.myProject.getBaseDir());
            if (relativePath == null) {
                Messages.showErrorDialog((Project)this.myProject, (String)"Please select file under project root.", (String)ADD_PROJECT_SCHEMA);
                return;
            }
            JsonSchemaChecker importer = new JsonSchemaChecker(file2, true);
            if (!importer.checkSchemaFile()) {
                if (!StringUtil.isEmptyOrSpaces((String)importer.getError())) {
                    JsonSchemaReader.ERRORS_NOTIFICATION.createNotification(importer.getError(), MessageType.ERROR).notify(this.myProject);
                    Messages.showErrorDialog((Project)this.myProject, (String)importer.getError(), (String)READ_JSON_SCHEMA);
                }
                return;
            }
            this.addCreatedMappings(file2, new JsonSchemaMappingsConfigurationBase.SchemaInfo(file2.getNameWithoutExtension(), relativePath, false, null));
        }
    }

    private void addCreatedMappings(@NotNull VirtualFile schemaFile, @NotNull JsonSchemaMappingsConfigurationBase.SchemaInfo info) {
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurable", "addCreatedMappings"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurable", "addCreatedMappings"));
        }
        JsonSchemaConfigurable configurable = new JsonSchemaConfigurable(this.myProject, FileUtil.toSystemDependentName((String)schemaFile.getPath()), info, this.myTreeUpdater);
        configurable.setError(this.myError);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable, info.isApplicationLevel());
        this.addNode(node, this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)node, true);
    }

    private void fillTree() {
        this.myRoot.removeAllChildren();
        if (this.myProject.isDefault()) {
            return;
        }
        List<JsonSchemaMappingsConfigurationBase.SchemaInfo> list = this.getStoredList();
        for (JsonSchemaMappingsConfigurationBase.SchemaInfo info : list) {
            JsonSchemaConfigurable configurable = new JsonSchemaConfigurable(this.myProject, new File(this.myProject.getBasePath(), info.getRelativePathToSchema()).getPath(), info, this.myTreeUpdater);
            configurable.setError(this.myError);
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)configurable, info.isApplicationLevel()));
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
        if (this.myRoot.children().hasMoreElements()) {
            this.myTree.addSelectionRow(0);
        }
    }

    @NotNull
    private List<JsonSchemaMappingsConfigurationBase.SchemaInfo> getStoredList() {
        Map<String, JsonSchemaMappingsConfigurationBase.SchemaInfo> projectState;
        ArrayList<JsonSchemaMappingsConfigurationBase.SchemaInfo> list = new ArrayList<JsonSchemaMappingsConfigurationBase.SchemaInfo>();
        if (this.myProject != null && (projectState = JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).getStateMap()) != null) {
            list.addAll(projectState.values());
        }
        Collections.sort(list, COMPARATOR);
        ArrayList<JsonSchemaMappingsConfigurationBase.SchemaInfo> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurable", "getStoredList"));
        }
        return arrayList;
    }

    public void apply() throws ConfigurationException {
        Project[] projects;
        List<JsonSchemaMappingsConfigurationBase.SchemaInfo> uiList = this.getUiList(true);
        JsonSchemaMappingsConfigurable.validate(uiList);
        HashMap<String, JsonSchemaMappingsConfigurationBase.SchemaInfo> projectMap = new HashMap<String, JsonSchemaMappingsConfigurationBase.SchemaInfo>();
        for (JsonSchemaMappingsConfigurationBase.SchemaInfo info : uiList) {
            if (info.isApplicationLevel()) continue;
            projectMap.put(info.getName(), info);
        }
        if (this.myProject != null) {
            JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).setState(projectMap);
        }
        for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
            JsonSchemaService service = JsonSchemaService.Impl.get(project2);
            if (service == null) continue;
            service.reset();
        }
        if (this.myProject != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        }
    }

    private static void validate(@NotNull List<JsonSchemaMappingsConfigurationBase.SchemaInfo> list) throws ConfigurationException {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurable", "validate"));
        }
        HashSet<String> set = new HashSet<String>();
        for (JsonSchemaMappingsConfigurationBase.SchemaInfo info : list) {
            if (set.contains(info.getName())) {
                throw new ConfigurationException("Duplicate schema name: '" + info.getName() + "'");
            }
            set.add(info.getName());
        }
    }

    public boolean isModified() {
        List<JsonSchemaMappingsConfigurationBase.SchemaInfo> uiList;
        List<JsonSchemaMappingsConfigurationBase.SchemaInfo> storedList = this.getStoredList();
        try {
            uiList = this.getUiList(false);
        }
        catch (ConfigurationException e) {
            return false;
        }
        return !storedList.equals(uiList);
    }

    private void updateWarningText() {
        List<JsonSchemaMappingsConfigurationBase.SchemaInfo> list;
        MultiMap patternsMap = new MultiMap();
        StringBuilder sb = new StringBuilder();
        try {
            list = this.getUiList(false);
        }
        catch (ConfigurationException e) {
            return;
        }
        for (JsonSchemaMappingsConfigurationBase.SchemaInfo info : list) {
            JsonSchemaPatternComparator comparator2 = new JsonSchemaPatternComparator(this.myProject);
            List<JsonSchemaMappingsConfigurationBase.Item> patterns = info.getPatterns();
            for (JsonSchemaMappingsConfigurationBase.Item pattern : patterns) {
                for (Map.Entry entry : patternsMap.entrySet()) {
                    for (JsonSchemaMappingsConfigurationBase.Item item : (Collection)entry.getValue()) {
                        ThreeState similar = comparator2.isSimilar(pattern, item);
                        if (ThreeState.NO.equals((Object)similar)) continue;
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append("'").append(pattern.getPresentation()).append("' for schema '").append(info.getName()).append("' and '").append(item.getPresentation()).append("' for schema '").append((String)entry.getKey()).append("'");
                    }
                }
            }
            patternsMap.put((Object)info.getName(), patterns);
        }
        this.myError = sb.length() > 0 ? "Conflicting mappings:\n" + sb.toString() : null;
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            Object o = children2.nextElement();
            if (!(o instanceof MasterDetailsComponent.MyNode) || !(((MasterDetailsComponent.MyNode)o).getConfigurable() instanceof JsonSchemaConfigurable)) continue;
            ((JsonSchemaConfigurable)((MasterDetailsComponent.MyNode)o).getConfigurable()).setError(this.myError);
        }
    }

    @NotNull
    private List<JsonSchemaMappingsConfigurationBase.SchemaInfo> getUiList(boolean applyChildren) throws ConfigurationException {
        ArrayList<JsonSchemaMappingsConfigurationBase.SchemaInfo> uiList = new ArrayList<JsonSchemaMappingsConfigurationBase.SchemaInfo>();
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)children2.nextElement();
            if (applyChildren) {
                node.getConfigurable().apply();
                uiList.add(JsonSchemaMappingsConfigurable.getSchemaInfo(node));
                continue;
            }
            uiList.add(((JsonSchemaConfigurable)node.getConfigurable()).getUiSchema());
        }
        Collections.sort(uiList, COMPARATOR);
        ArrayList<JsonSchemaMappingsConfigurationBase.SchemaInfo> arrayList = uiList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurable", "getUiList"));
        }
        return arrayList;
    }

    public void reset() {
        this.fillTree();
        this.updateWarningText();
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return new Comparator<MasterDetailsComponent.MyNode>(){

            @Override
            public int compare(MasterDetailsComponent.MyNode o1, MasterDetailsComponent.MyNode o2) {
                if (o1.getConfigurable() instanceof JsonSchemaConfigurable && o2.getConfigurable() instanceof JsonSchemaConfigurable) {
                    return COMPARATOR.compare(JsonSchemaMappingsConfigurable.getSchemaInfo(o1), JsonSchemaMappingsConfigurable.getSchemaInfo(o2));
                }
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        };
    }

    private static JsonSchemaMappingsConfigurationBase.SchemaInfo getSchemaInfo(@NotNull MasterDetailsComponent.MyNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurable", "getSchemaInfo"));
        }
        return ((JsonSchemaConfigurable)node.getConfigurable()).getSchema();
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    @Nls
    public String getDisplayName() {
        return JSON_SCHEMA_MAPPINGS;
    }

    public void dispose() {
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            Object o = children2.nextElement();
            if (!(o instanceof MasterDetailsComponent.MyNode)) continue;
            ((MasterDetailsComponent.MyNode)o).getConfigurable().disposeUIResources();
        }
    }

    @NotNull
    public String getId() {
        if (SETTINGS_JSON_SCHEMA == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaMappingsConfigurable", "getId"));
        }
        return SETTINGS_JSON_SCHEMA;
    }

    public String getHelpTopic() {
        return SETTINGS_JSON_SCHEMA;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    public static class JsonSchemaChecker {
        private static final int MAX_SCHEMA_LENGTH = 0x100000;
        private final boolean myLoadText;
        private final VirtualFile myFile;
        @Nullable
        private String myText;
        @Nullable
        private String myError;

        public JsonSchemaChecker(VirtualFile file2, boolean loadText) {
            this.myLoadText = loadText;
            this.myFile = file2;
        }

        public boolean checkSchemaFile() {
            Object text = null;
            try {
                File ioFile = new File(this.myFile.getPath());
                long length = ioFile.length();
                if (length > 0x100000L) {
                    this.myError = "JSON schema was not loaded from '" + this.myFile.getName() + "' because it's too large (file size is " + length + " bytes).";
                    return false;
                }
                if (length == 0L) {
                    this.myError = "JSON schema was not loaded from '" + this.myFile.getName() + "'. File is empty.";
                    return false;
                }
                this.myText = FileUtil.loadFile((File)ioFile);
            }
            catch (IOException e1) {
                JsonSchemaReader.LOG.info((Throwable)e1);
                this.myError = "Problem during reading JSON schema from '" + this.myFile.getName() + "': " + e1.getMessage();
                return false;
            }
            CollectConsumer collectConsumer = new CollectConsumer();
            if (!JsonSchemaReader.isJsonSchema(this.myText, (Consumer<String>)collectConsumer)) {
                this.myError = "JSON Schema not found or contain error in '" + this.myFile.getName() + "'";
                if (!collectConsumer.getResult().isEmpty()) {
                    this.myError = this.myError + ": " + StringUtil.join((Collection)collectConsumer.getResult(), (String)"; ");
                }
                return false;
            }
            if (!this.myLoadText) {
                this.myText = null;
            }
            return true;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        @Nullable
        public String getText() {
            return this.myText;
        }

        @Nullable
        public String getError() {
            return this.myError;
        }
    }
}

