/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.json.JsonFileType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ResourceUtil;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaSelfProviderFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaProjectSelfProviderFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.jsonSchema.extension.JsonSchemaProjectSelfProviderFactory");
    private final JsonSchemaFileProvider[] myProviders;

    public static JsonSchemaProjectSelfProviderFactory getInstance(Project project2) {
        return (JsonSchemaProjectSelfProviderFactory)ServiceManager.getService((Project)project2, JsonSchemaProjectSelfProviderFactory.class);
    }

    public JsonSchemaProjectSelfProviderFactory(Project project2) {
        this.myProviders = new JsonSchemaFileProvider[]{new MyJsonSchemaFileProvider(project2)};
    }

    public JsonSchemaFileProvider[] getProviders() {
        return this.myProviders;
    }

    private static class MyJsonSchemaFileProvider
    implements JsonSchemaFileProvider {
        private final Project myProject;

        public MyJsonSchemaFileProvider(Project project2) {
            this.myProject = project2;
        }

        @Override
        public boolean isAvailable(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$MyJsonSchemaFileProvider", "isAvailable"));
            }
            if (this.myProject == null || !((Object)((Object)JsonFileType.INSTANCE)).equals(file2.getFileType())) {
                return false;
            }
            return JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).isRegisteredSchemaFile(file2);
        }

        @Override
        @Nullable
        public Reader getSchemaReader() {
            String content = MyJsonSchemaFileProvider.getContent();
            return content == null ? null : new StringReader(content);
        }

        @Override
        @NotNull
        public String getName() {
            if ("schema.json" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$MyJsonSchemaFileProvider", "getName"));
            }
            return "schema.json";
        }

        @Nullable
        private static String getContent() {
            ClassLoader loader = JsonSchemaSelfProviderFactory.class.getClassLoader();
            try {
                URL resource = loader.getResource("jsonSchema/schema.json");
                assert (resource != null);
                return ResourceUtil.loadText((URL)resource);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyJsonSchemaFileProvider provider = (MyJsonSchemaFileProvider)o;
            return !(this.myProject != null ? !this.myProject.equals(provider.myProject) : provider.myProject != null);
        }

        public int hashCode() {
            return this.myProject != null ? this.myProject.hashCode() : 0;
        }
    }
}

