/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.encapsulation.PublicFieldInspectionBase;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.fixes.EncapsulateVariableFix;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicFieldInspection
extends PublicFieldInspectionBase {
    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel annotationsListControl = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.ignorableAnnotations), InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]));
        panel.add((Component)annotationsListControl, "Center");
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("public.field.ignore.enum.type.fields.option", new Object[0]), (InspectionProfileEntry)this, "ignoreEnums");
        panel.add((Component)checkBox, "South");
        return panel;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        PsiField field = (PsiField)infos[0];
        fixes.add(new EncapsulateVariableFix(field.getName()));
        AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)field, (List<String>)((Object)this.ignorableAnnotations), fixes);
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(new InspectionGadgetsFix[fixes.size()]);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/PublicFieldInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }
}

