/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class AddThisQualifierFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/AddThisQualifierFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("add.this.qualifier.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/AddThisQualifierFix", "getName"));
        }
        return string;
    }

    @Override
    public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
        String newExpression;
        PsiReferenceExpression expression = (PsiReferenceExpression)descriptor.getPsiElement();
        if (expression.getQualifierExpression() != null) {
            return;
        }
        PsiElement target = expression.resolve();
        if (!(target instanceof PsiMember)) {
            return;
        }
        PsiMember member = (PsiMember)target;
        PsiClass memberClass = member.getContainingClass();
        if (memberClass == null) {
            return;
        }
        PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression);
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
            newExpression = "this." + expression.getText();
        } else {
            if ((containingClass = ClassUtils.getContainingClass((PsiElement)containingClass)) == null) {
                return;
            }
            while (!InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
                if ((containingClass = ClassUtils.getContainingClass((PsiElement)containingClass)) != null) continue;
                return;
            }
            newExpression = containingClass.getQualifiedName() + ".this." + expression.getText();
        }
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression, newExpression);
    }
}

