/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class InvertBooleanFix
extends InspectionGadgetsFix {
    private final String myName;

    public InvertBooleanFix(String name) {
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/InvertBooleanFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("invert.quickfix.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/InvertBooleanFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void doFix(final Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
        final PsiNameIdentifierOwner owner = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), (Class[])new Class[]{PsiVariable.class, PsiMethod.class});
        if (owner == null) {
            return;
        }
        final RefactoringActionHandler handler2 = JavaRefactoringActionHandlerFactory.getInstance().createInvertBooleanHandler();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                handler2.invoke(project2, new PsiElement[]{owner}, null);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2, project2.getDisposed());
        }
    }
}

