/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ExtendsConcreteCollectionInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ClassExtendsConcreteCollection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspectionBase", "getID"));
        }
        return "ClassExtendsConcreteCollection";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("extends.concrete.collection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        PsiClass aClass = (PsiClass)infos[1];
        if (aClass instanceof PsiAnonymousClass) {
            String string = InspectionGadgetsBundle.message("anonymous.extends.concrete.collection.problem.descriptor", superClass.getQualifiedName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("extends.concrete.collection.problem.descriptor", superClass.getQualifiedName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsConcreteCollectionVisitor();
    }

    private static class ExtendsConcreteCollectionVisitor
    extends BaseInspectionVisitor {
        private ExtendsConcreteCollectionVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspectionBase$ExtendsConcreteCollectionVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            PsiClass superClass = aClass.getSuperClass();
            if (!CollectionUtils.isConcreteCollectionClass(superClass)) {
                return;
            }
            String qualifiedName = superClass.getQualifiedName();
            if ("java.util.LinkedHashMap".equals(qualifiedName)) {
                PsiMethod[] methods = aClass.findMethodsByName("removeEldestEntry", false);
                PsiClassType entryType = TypeUtils.getType("java.util.Map.Entry", (PsiElement)aClass);
                for (PsiMethod method : methods) {
                    PsiParameter parameter;
                    PsiParameterList parameterList;
                    if (!PsiType.BOOLEAN.equals((Object)method.getReturnType()) || (parameterList = method.getParameterList()).getParametersCount() != 1 || !entryType.isAssignableFrom((parameter = parameterList.getParameters()[0]).getType())) continue;
                    return;
                }
            }
            this.registerClassError(aClass, superClass, aClass);
        }
    }
}

