/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class TeardownCallsSuperTeardownInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("TearDownDoesntCallSuperTearDown" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection", "getID"));
        }
        return "TearDownDoesntCallSuperTearDown";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("teardown.calls.super.teardown.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("teardown.calls.super.teardown.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddSuperTearDownCall();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TeardownCallsSuperTeardownVisitor("tearDown");
    }

    public static class TeardownCallsSuperTeardownVisitor
    extends BaseInspectionVisitor {
        private final String myMethodName;

        public TeardownCallsSuperTeardownVisitor(String methodName) {
            this.myMethodName = methodName;
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection$TeardownCallsSuperTeardownVisitor", "visitMethod"));
            }
            String methodName = method.getName();
            if (!this.myMethodName.equals(methodName)) {
                return;
            }
            if (method.hasModifierProperty("abstract")) {
                return;
            }
            if (method.getBody() == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)targetClass, (String)"junit.framework.TestCase")) {
                return;
            }
            if (MethodCallUtils.containsSuperMethodCall(this.myMethodName, (PsiElement)method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }

    private static class AddSuperTearDownCall
    extends InspectionGadgetsFix {
        private AddSuperTearDownCall() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("teardown.calls.super.teardown.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection$AddSuperTearDownCall", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection$AddSuperTearDownCall", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodName = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodName.getParent();
            if (method == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiStatement newStatement = factory.createStatementFromText("super.tearDown();", null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project2);
            PsiJavaToken brace = body.getRBrace();
            body.addBefore((PsiElement)newStatement, (PsiElement)brace);
            styleManager.reformat((PsiElement)body);
        }
    }
}

