/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoCloseableResourceInspectionBase
extends ResourceInspection {
    private static final List<String> DEFAULT_IGNORED_TYPES = Arrays.asList("java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream");
    public boolean ignoreFromMethodCall = false;
    final List<String> ignoredTypes = new ArrayList<String>(DEFAULT_IGNORED_TYPES);
    protected final MethodMatcher myMethodMatcher = new MethodMatcher().add("java.util.Formatter", "format").add("java.io.Writer", "append").add("com.google.common.base.Preconditions", "checkNotNull").add("org.hibernate.Session", "close").finishDefault();

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("auto.closeable.resource.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("resource" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase", "getID"));
        }
        return "resource";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("auto.closeable.resource.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean buildQuickfix = (Boolean)infos[1];
        if (!buildQuickfix) {
            return null;
        }
        return new AutoCloseableResourceFix();
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            String ignoredTypesString;
            String name = option.getAttributeValue("name");
            if (!"ignoredTypes".equals(name) || (ignoredTypesString = option.getAttributeValue("value")) == null) continue;
            this.ignoredTypes.clear();
            AutoCloseableResourceInspectionBase.parseString(ignoredTypesString, this.ignoredTypes);
        }
        this.myMethodMatcher.readSettings(node);
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase", "writeSettings"));
        }
        this.writeBooleanOption(node, "ignoreFromMethodCall", false);
        this.writeBooleanOption(node, "anyMethodMayClose", true);
        if (!DEFAULT_IGNORED_TYPES.equals(this.ignoredTypes)) {
            String ignoredTypesString = AutoCloseableResourceInspectionBase.formatString(this.ignoredTypes);
            node.addContent(new Element("option").setAttribute("name", "ignoredTypes").setAttribute("value", ignoredTypesString));
        }
        this.myMethodMatcher.writeSettings(node);
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression) {
        return TypeUtils.expressionHasTypeOrSubtype(expression, "java.lang.AutoCloseable") && !TypeUtils.expressionHasTypeOrSubtype(expression, this.ignoredTypes);
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel7OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AutoCloseableResourceVisitor();
    }

    private class AutoCloseableResourceVisitor
    extends BaseInspectionVisitor {
        private AutoCloseableResourceVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (!this.isNotSafelyClosedResource((PsiExpression)expression)) {
                return;
            }
            this.registerNewExpressionError(expression, expression.getType(), Boolean.FALSE);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (AutoCloseableResourceInspectionBase.this.ignoreFromMethodCall || AutoCloseableResourceInspectionBase.this.myMethodMatcher.matches(expression) || !this.isNotSafelyClosedResource((PsiExpression)expression)) {
                return;
            }
            this.registerMethodCallError(expression, expression.getType(), Boolean.TRUE);
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            super.visitMethodReferenceExpression(expression);
            if (!expression.isConstructor()) {
                return;
            }
            PsiType type = PsiMethodReferenceUtil.getQualifierType((PsiMethodReferenceExpression)expression);
            if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.AutoCloseable")) {
                return;
            }
            for (String ignoredType : AutoCloseableResourceInspectionBase.this.ignoredTypes) {
                if (!InheritanceUtil.isInheritor((PsiType)type, (String)ignoredType)) continue;
                return;
            }
            this.registerError((PsiElement)expression, type, Boolean.FALSE);
        }

        private boolean isNotSafelyClosedResource(PsiExpression expression) {
            if (!AutoCloseableResourceInspectionBase.this.isResourceCreation(expression)) {
                return false;
            }
            PsiVariable variable = ResourceInspection.getVariable(expression);
            return !(variable instanceof PsiResourceVariable) && !AutoCloseableResourceInspectionBase.this.isResourceEscapingFromMethod(variable, expression);
        }
    }

    private class AutoCloseableResourceFix
    extends InspectionGadgetsFix {
        private AutoCloseableResourceFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("auto.closeable.resource.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase$AutoCloseableResourceFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase$AutoCloseableResourceFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return;
            }
            AutoCloseableResourceInspectionBase.this.myMethodMatcher.add(methodCallExpression);
        }
    }
}

