/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.annotation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNameValuePair;
import com.siyeh.ipp.annotation.ExpandToNormalAnnotationPredicate;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class ExpandToNormalAnnotationIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ExpandToNormalAnnotationPredicate expandToNormalAnnotationPredicate = new ExpandToNormalAnnotationPredicate();
        if (expandToNormalAnnotationPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/annotation/ExpandToNormalAnnotationIntention", "getElementPredicate"));
        }
        return expandToNormalAnnotationPredicate;
    }

    public static String buildReplacementText(PsiAnnotationParameterList annotationParameterList) {
        StringBuilder text = new StringBuilder();
        for (PsiNameValuePair nameValuePair : annotationParameterList.getAttributes()) {
            String name;
            if (text.length() != 0) {
                text.append(',');
            }
            text.append((name = nameValuePair.getName()) != null ? name : "value").append('=');
            PsiAnnotationMemberValue value = nameValuePair.getValue();
            if (value == null) continue;
            text.append(value.getText());
        }
        return text.toString();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/annotation/ExpandToNormalAnnotationIntention", "processIntention"));
        }
        PsiAnnotationParameterList annotationParameterList = (PsiAnnotationParameterList)element.getParent();
        String text = ExpandToNormalAnnotationIntention.buildReplacementText(annotationParameterList);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)annotationParameterList.getProject());
        PsiAnnotation newAnnotation = factory.createAnnotationFromText("@A(" + text + " )", element);
        annotationParameterList.replace((PsiElement)newAnnotation.getParameterList());
    }
}

