/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;

class ConvertIntegerToDecimalPredicate
implements PsiElementPredicate {
    ConvertIntegerToDecimalPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)element;
        PsiType type = expression.getType();
        if (PsiType.INT.equals((Object)type) || PsiType.LONG.equals((Object)type)) {
            String text = expression.getText();
            if (text == null || text.length() < 2) {
                return false;
            }
            if ("0".equals(text) || "0L".equals(text) || "0l".equals(text)) {
                return false;
            }
            return text.charAt(0) == '0';
        }
        if (PsiType.DOUBLE.equals((Object)type) || PsiType.FLOAT.equals((Object)type)) {
            String text = expression.getText();
            if (text == null || text.length() < 2) {
                return false;
            }
            return text.startsWith("0x") || text.startsWith("0X");
        }
        return false;
    }
}

