/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiReference;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncRef;
import org.intellij.plugins.relaxNG.compact.psi.impl.PatternReference;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncElementImpl;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RncRefImpl
extends RncElementImpl
implements RncRef {
    public RncRefImpl(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public RncDefine getPattern() {
        PsiReference ref = this.getReference();
        return ref instanceof PatternReference ? (RncDefine)ref.resolve() : null;
    }

    @Override
    public String getReferencedName() {
        ASTNode node = this.findNameNode();
        assert (node != null);
        return EscapeUtil.unescapeText(node);
    }

    protected ASTNode findNameNode() {
        return this.getNode().findChildByType(RncTokenTypes.IDENTIFIERS);
    }

    @Override
    public void accept(@NotNull RncElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/intellij/plugins/relaxNG/compact/psi/impl/RncRefImpl", "accept"));
        }
        visitor.visitRef(this);
    }

    @Override
    public void accept(CommonElement.Visitor visitor) {
        visitor.visitRef(this);
    }

    @Override
    public PsiReference getReference() {
        return new PatternReference(this);
    }
}

