/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NotNull;

abstract class CommonAnnotationHolder<C> {
    CommonAnnotationHolder() {
    }

    public static <T extends DomElement> CommonAnnotationHolder<T> create(DomElementAnnotationHolder holder) {
        return new DomHolderAdapter(holder);
    }

    public static <T extends PsiElement> CommonAnnotationHolder<T> create(AnnotationHolder holder) {
        return new HolderAdapter(holder);
    }

    public abstract Annotation createAnnotation(C var1, @NotNull HighlightSeverity var2, String var3);

    private static class HolderAdapter<T extends PsiElement>
    extends CommonAnnotationHolder<T> {
        private final AnnotationHolder myHolder;

        HolderAdapter(AnnotationHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public Annotation createAnnotation(T element, @NotNull HighlightSeverity severity, String message) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/intellij/plugins/relaxNG/model/annotation/CommonAnnotationHolder$HolderAdapter", "createAnnotation"));
            }
            if (severity == HighlightSeverity.ERROR) {
                return this.myHolder.createErrorAnnotation(element, message);
            }
            if (severity == HighlightSeverity.WARNING) {
                return this.myHolder.createWarningAnnotation(element, message);
            }
            if (severity == HighlightSeverity.WEAK_WARNING) {
                return this.myHolder.createWeakWarningAnnotation(element, message);
            }
            return this.myHolder.createInfoAnnotation(element, message);
        }
    }

    private static class DomHolderAdapter<T extends DomElement>
    extends CommonAnnotationHolder<T> {
        private final DomElementAnnotationHolder myHolder;

        DomHolderAdapter(DomElementAnnotationHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public Annotation createAnnotation(DomElement element, @NotNull HighlightSeverity severity, String message) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/intellij/plugins/relaxNG/model/annotation/CommonAnnotationHolder$DomHolderAdapter", "createAnnotation"));
            }
            Annotation annotation = this.myHolder.createAnnotation(element, severity, message);
            annotation.setTooltip(message);
            return annotation;
        }
    }
}

