/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.google.common.net.InetAddresses;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.NettyKt;
import org.jetbrains.io.NettyUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000|\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0012\u001a\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0002H\u0002\u001a\u0006\u0010\u0017\u001a\u00020\u0018\u001a&\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0012H\u0007\u001a\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a#\u0010\u001f\u001a\u00020 *\u00020!2\u0014\b\u0004\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020 0#H\u0086\b\u001a\n\u0010$\u001a\u00020 *\u00020\f\u001aB\u0010%\u001a\u0004\u0018\u00010\f*\u00020\u00182\u0006\u0010&\u001a\u00020'2\u000e\b\u0002\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010)2\b\b\u0002\u0010*\u001a\u00020+2\u0010\b\u0002\u0010,\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010-H\u0007\u001a#\u0010/\u001a\u00020\u0018*\u00020\u00182\u0014\b\u0004\u00100\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020 0#H\u0086\b\u001a \u00101\u001a\u00020\u0012*\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0012H\u0007\u001a\n\u00102\u001a\u00020\u0012*\u00020\u0005\u001a\n\u00103\u001a\u00020\u0012*\u00020\u0005\u001a&\u00104\u001a\u0002H5\"\u0004\b\u0000\u00105*\u0002062\f\u00100\u001a\b\u0012\u0004\u0012\u0002H507H\u0086\b\u00a2\u0006\u0002\u00108\u001a\n\u00109\u001a\u00020 *\u00020:\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\"\u0017\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006;"}, d2={"host", "", "Lcom/intellij/util/Url;", "getHost", "(Lcom/intellij/util/Url;)Ljava/lang/String;", "Lio/netty/handler/codec/http/HttpRequest;", "(Lio/netty/handler/codec/http/HttpRequest;)Ljava/lang/String;", "origin", "getOrigin", "referrer", "getReferrer", "uriScheme", "Lio/netty/channel/Channel;", "getUriScheme", "(Lio/netty/channel/Channel;)Ljava/lang/String;", "userAgent", "getUserAgent", "isLocalHost", "", "onlyAnyOrLoopback", "hostsOnly", "isTrustedChromeExtension", "url", "oioClientBootstrap", "Lio/netty/bootstrap/Bootstrap;", "parseAndCheckIsLocalHost", "uri", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "group", "Lio/netty/channel/EventLoopGroup;", "addChannelListener", "", "Lio/netty/channel/ChannelFuture;", "listener", "Lkotlin/Function1;", "closeAndShutdownEventLoop", "connect", "remoteAddress", "Ljava/net/InetSocketAddress;", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "maxAttemptCount", "", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "handler", "task", "isLocalOrigin", "isRegularBrowser", "isWriteFromBrowserWithoutOrigin", "releaseIfError", "T", "Lio/netty/buffer/ByteBuf;", "Lkotlin/Function0;", "(Lio/netty/buffer/ByteBuf;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "shutdownIfOio", "Lio/netty/channel/EventLoop;", "platform-impl"})
public final class NettyKt {
    @NotNull
    public static final Bootstrap handler(Bootstrap $receiver, @NotNull Function1<? super Channel, Unit> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        $receiver.handler((ChannelHandler)new ChannelInitializer<Channel>(task){
            final /* synthetic */ Function1 $task;

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                this.$task.invoke((Object)channel);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
        return $receiver;
    }

    @NotNull
    public static final ServerBootstrap serverBootstrap(@NotNull EventLoopGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(group).channel(group instanceof NioEventLoopGroup ? NioServerSocketChannel.class : OioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ServerBootstrap serverBootstrap = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)serverBootstrap, (String)"bootstrap");
        return serverBootstrap;
    }

    @NotNull
    public static final Bootstrap oioClientBootstrap() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new OioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE))).channel(OioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Bootstrap bootstrap2 = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"bootstrap");
        return bootstrap2;
    }

    public static final void addChannelListener(ChannelFuture $receiver, @NotNull Function1<? super ChannelFuture, Unit> listener2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(listener2){
            final /* synthetic */ Function1 $listener;

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                this.$listener.invoke((Object)channelFuture);
            }
            {
                this.$listener = function1;
            }
        });
    }

    public static final void shutdownIfOio(EventLoop $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof OioEventLoopGroup) {
            EventLoop eventLoop = $receiver;
            if (eventLoop == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.netty.channel.oio.OioEventLoopGroup");
            }
            ((OioEventLoopGroup)eventLoop).shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeAndShutdownEventLoop(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        EventLoop eventLoop = $receiver.eventLoop();
        try {
            $receiver.close().awaitUninterruptibly();
        }
        finally {
            NettyKt.shutdownIfOio(eventLoop);
        }
    }

    @JvmOverloads
    @Nullable
    public static final Channel connect(Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress, @Nullable AsyncPromise<?> promise2, int maxAttemptCount, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)remoteAddress, (String)"remoteAddress");
        try {
            Condition condition = stopCondition;
            if (condition == null) {
                condition = Conditions.alwaysFalse();
            }
            return NettyUtil.doConnect($receiver, remoteAddress, promise2, maxAttemptCount, condition);
        }
        catch (Throwable e) {
            AsyncPromise<?> asyncPromise = promise2;
            Boolean bl = asyncPromise != null ? Boolean.valueOf(asyncPromise.setError(e)) : null;
            return null;
        }
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ Channel connect$default(Bootstrap bootstrap, InetSocketAddress inetSocketAddress, AsyncPromise asyncPromise, int n, Condition condition, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: connect");
        }
        if ((n2 & 2) != 0) {
            asyncPromise = null;
        }
        if ((n2 & 4) != 0) {
            n = 20;
        }
        if ((n2 & 8) != 0) {
            condition = null;
        }
        return NettyKt.connect(bootstrap, inetSocketAddress, asyncPromise, n, (Condition<Void>)condition);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap $receiver, @Nullable InetSocketAddress remoteAddress, @NotNull AsyncPromise<?> promise2, int maxAttemptCount) {
        return NettyKt.connect$default($receiver, remoteAddress, promise2, maxAttemptCount, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap $receiver, @Nullable InetSocketAddress remoteAddress, AsyncPromise<?> promise2) {
        return NettyKt.connect$default($receiver, remoteAddress, promise2, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap $receiver, InetSocketAddress remoteAddress) {
        return NettyKt.connect$default($receiver, remoteAddress, null, 0, null, 14, null);
    }

    @NotNull
    public static final String getUriScheme(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.pipeline().get(SslHandler.class) == null ? "http" : "https";
    }

    @Nullable
    public static final String getHost(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
    }

    @Nullable
    public static final String getOrigin(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.ORIGIN);
    }

    @Nullable
    public static final String getReferrer(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.REFERER);
    }

    @Nullable
    public static final String getUserAgent(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.USER_AGENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T releaseIfError(ByteBuf $receiver, @NotNull Function0<? extends T> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            return (T)task.invoke();
        }
        catch (Exception e) {
            try {
                $receiver.release();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                throw (Throwable)e;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isLocalHost(@NotNull String host, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        if (onlyAnyOrLoopback && !InetAddresses.isInetAddress((String)host)) {
            return false;
        }
        isLocalHost.1 isLocal$ = isLocalHost.1.INSTANCE;
        try {
            InetAddress address = InetAddress.getByName(host);
            if (!isLocal$.invoke(address)) {
                return false;
            }
            if (hostsOnly && !InetAddresses.isInetAddress((String)host)) {
                void $receiver$iv;
                InetAddress inetAddress = HostsFileEntriesResolver.DEFAULT.address(host);
                InetAddress it = (InetAddress)$receiver$iv;
                return it != null && isLocalHost.1.INSTANCE.invoke(it);
            }
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static /* bridge */ /* synthetic */ boolean isLocalHost$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isLocalHost");
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalHost(string, bl, bl2);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(HttpRequest $receiver, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return NettyKt.parseAndCheckIsLocalHost(NettyKt.getOrigin($receiver), onlyAnyOrLoopback, hostsOnly) && NettyKt.parseAndCheckIsLocalHost(NettyKt.getReferrer($receiver), onlyAnyOrLoopback, hostsOnly);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean isLocalOrigin$default(HttpRequest httpRequest, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isLocalOrigin");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalOrigin(httpRequest, bl, bl2);
    }

    @JvmOverloads
    public static boolean isLocalOrigin(@NotNull HttpRequest $receiver, boolean onlyAnyOrLoopback) {
        return NettyKt.isLocalOrigin$default($receiver, onlyAnyOrLoopback, false, 2, null);
    }

    @JvmOverloads
    public static boolean isLocalOrigin(HttpRequest $receiver) {
        return NettyKt.isLocalOrigin$default($receiver, false, false, 3, null);
    }

    private static final boolean isTrustedChromeExtension(Url url) {
        return Intrinsics.areEqual((Object)url.getScheme(), (Object)"chrome-extension") && (Intrinsics.areEqual((Object)url.getAuthority(), (Object)"hmhgeddbohgjknpmjagkdomcpobmllji") || Intrinsics.areEqual((Object)url.getAuthority(), (Object)"offnedcbhjldheanlbojaefbfbllddna"));
    }

    /*
     * WARNING - void declaration
     */
    private static final String getHost(Url $receiver) {
        String string;
        String string2 = $receiver.getAuthority();
        if (string2 != null) {
            String string3;
            String $receiver$iv = string2;
            String it = $receiver$iv;
            int portIndex = StringsKt.indexOf$default((CharSequence)it, (char)':', (int)0, (boolean)false, (int)6, null);
            if (portIndex > 0) {
                void startIndex$iv;
                void $receiver$iv2;
                String string4 = it;
                boolean bl = false;
                void v1 = $receiver$iv2;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = ((String)v1).substring((int)startIndex$iv, portIndex);
                string3 = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                void var2_2;
                string3 = var2_2;
            }
            string = string3;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@Nullable String uri, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        if (uri == null) {
            return true;
        }
        try {
            Url url = Urls.parse(uri, false);
            if (url == null) return false;
            Url parsedUri = url;
            String host = NettyKt.getHost(parsedUri);
            if (host == null) return false;
            Url url2 = parsedUri;
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"parsedUri");
            if (NettyKt.isTrustedChromeExtension(url2)) return true;
            if (!NettyKt.isLocalHost(host, onlyAnyOrLoopback, hostsOnly)) return false;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean parseAndCheckIsLocalHost$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseAndCheckIsLocalHost");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.parseAndCheckIsLocalHost(string, bl, bl2);
    }

    @JvmOverloads
    public static boolean parseAndCheckIsLocalHost(@Nullable String uri, boolean onlyAnyOrLoopback) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri, onlyAnyOrLoopback, false, 4, null);
    }

    @JvmOverloads
    public static boolean parseAndCheckIsLocalHost(@Nullable String uri) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri, false, false, 6, null);
    }

    public static final boolean isRegularBrowser(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = NettyKt.getUserAgent($receiver);
        return string != null ? StringsKt.startsWith$default((String)string, (String)"Mozilla/5.0", (boolean)false, (int)2, null) : false;
    }

    public static final boolean isWriteFromBrowserWithoutOrigin(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        HttpMethod method = $receiver.method();
        CharSequence $receiver$iv = NettyKt.getOrigin($receiver);
        return ($receiver$iv == null || $receiver$iv.length() == 0) && NettyKt.isRegularBrowser($receiver) && (Intrinsics.areEqual((Object)method, (Object)HttpMethod.POST) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.PATCH) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.PUT) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.DELETE));
    }
}

