/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer byteBuffer;

    public ByteBufferInputStream() {
    }

    public ByteBufferInputStream(int n) {
        this(ByteBuffer.allocate(n));
        this.byteBuffer.flip();
    }

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public int read() throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            return -1;
        }
        return this.byteBuffer.get();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(this.byteBuffer.remaining(), n2);
        if (n3 == 0) {
            return -1;
        }
        this.byteBuffer.get(byArray, n, n3);
        return n3;
    }

    @Override
    public int available() throws IOException {
        return this.byteBuffer.remaining();
    }
}

