/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.ObjectField;

public class AsmCacheFields {

    static final class AsmObjectField
    extends ObjectField {
        public AsmObjectField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            if (this.accessIndex != -1) {
                return this.access.get(object, this.accessIndex);
            }
            throw new KryoException("Unknown acess index");
        }

        @Override
        public void setField(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
            if (this.accessIndex == -1) {
                throw new KryoException("Unknown acess index");
            }
            this.access.set(object, this.accessIndex, object2);
        }

        @Override
        public void copy(Object object, Object object2) {
            try {
                if (this.accessIndex == -1) {
                    throw new KryoException("Unknown acess index");
                }
                this.access.set(object2, this.accessIndex, this.kryo.copy(this.access.get(object, this.accessIndex)));
            }
            catch (KryoException kryoException) {
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
            catch (RuntimeException runtimeException) {
                KryoException kryoException = new KryoException(runtimeException);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }
    }

    static final class StringField
    extends AsmCachedField {
        StringField() {
        }

        @Override
        public void write(Output output, Object object) {
            output.writeString(this.access.getString(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            this.access.set(object, this.accessIndex, (Object)input.readString());
        }

        @Override
        public void copy(Object object, Object object2) {
            this.access.set(object2, this.accessIndex, (Object)this.access.getString(object, this.accessIndex));
        }
    }

    static final class DoubleField
    extends AsmCachedField {
        DoubleField() {
        }

        @Override
        public void write(Output output, Object object) {
            output.writeDouble(this.access.getDouble(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            this.access.setDouble(object, this.accessIndex, input.readDouble());
        }

        @Override
        public void copy(Object object, Object object2) {
            this.access.setDouble(object2, this.accessIndex, this.access.getDouble(object, this.accessIndex));
        }
    }

    static final class LongField
    extends AsmCachedField {
        LongField() {
        }

        @Override
        public void write(Output output, Object object) {
            if (this.varIntsEnabled) {
                output.writeLong(this.access.getLong(object, this.accessIndex), false);
            } else {
                output.writeLong(this.access.getLong(object, this.accessIndex));
            }
        }

        @Override
        public void read(Input input, Object object) {
            if (this.varIntsEnabled) {
                this.access.setLong(object, this.accessIndex, input.readLong(false));
            } else {
                this.access.setLong(object, this.accessIndex, input.readLong());
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            this.access.setLong(object2, this.accessIndex, this.access.getLong(object, this.accessIndex));
        }
    }

    static final class CharField
    extends AsmCachedField {
        CharField() {
        }

        @Override
        public void write(Output output, Object object) {
            output.writeChar(this.access.getChar(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            this.access.setChar(object, this.accessIndex, input.readChar());
        }

        @Override
        public void copy(Object object, Object object2) {
            this.access.setChar(object2, this.accessIndex, this.access.getChar(object, this.accessIndex));
        }
    }

    static final class BooleanField
    extends AsmCachedField {
        BooleanField() {
        }

        @Override
        public void write(Output output, Object object) {
            output.writeBoolean(this.access.getBoolean(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            this.access.setBoolean(object, this.accessIndex, input.readBoolean());
        }

        @Override
        public void copy(Object object, Object object2) {
            this.access.setBoolean(object2, this.accessIndex, this.access.getBoolean(object, this.accessIndex));
        }
    }

    static final class ByteField
    extends AsmCachedField {
        ByteField() {
        }

        @Override
        public void write(Output output, Object object) {
            output.writeByte(this.access.getByte(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            this.access.setByte(object, this.accessIndex, input.readByte());
        }

        @Override
        public void copy(Object object, Object object2) {
            this.access.setByte(object2, this.accessIndex, this.access.getByte(object, this.accessIndex));
        }
    }

    static final class ShortField
    extends AsmCachedField {
        ShortField() {
        }

        @Override
        public void write(Output output, Object object) {
            output.writeShort(this.access.getShort(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            this.access.setShort(object, this.accessIndex, input.readShort());
        }

        @Override
        public void copy(Object object, Object object2) {
            this.access.setShort(object2, this.accessIndex, this.access.getShort(object, this.accessIndex));
        }
    }

    static final class FloatField
    extends AsmCachedField {
        FloatField() {
        }

        @Override
        public void write(Output output, Object object) {
            output.writeFloat(this.access.getFloat(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            this.access.setFloat(object, this.accessIndex, input.readFloat());
        }

        @Override
        public void copy(Object object, Object object2) {
            this.access.setFloat(object2, this.accessIndex, this.access.getFloat(object, this.accessIndex));
        }
    }

    static final class IntField
    extends AsmCachedField {
        IntField() {
        }

        @Override
        public void write(Output output, Object object) {
            if (this.varIntsEnabled) {
                output.writeInt(this.access.getInt(object, this.accessIndex), false);
            } else {
                output.writeInt(this.access.getInt(object, this.accessIndex));
            }
        }

        @Override
        public void read(Input input, Object object) {
            if (this.varIntsEnabled) {
                this.access.setInt(object, this.accessIndex, input.readInt(false));
            } else {
                this.access.setInt(object, this.accessIndex, input.readInt());
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            this.access.setInt(object2, this.accessIndex, this.access.getInt(object, this.accessIndex));
        }
    }

    static abstract class AsmCachedField
    extends FieldSerializer.CachedField {
        AsmCachedField() {
        }
    }
}

