/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;

public class DefaultArraySerializers {

    public static class ObjectArraySerializer
    extends Serializer<Object[]> {
        private boolean elementsAreSameType;
        private boolean elementsCanBeNull = true;
        private Class[] generics;
        private final Class type;
        private final Kryo kryo;

        public ObjectArraySerializer(Kryo kryo, Class clazz) {
            boolean bl;
            this.setAcceptsNull(true);
            this.kryo = kryo;
            this.type = clazz;
            Class<?> clazz2 = clazz.getComponentType();
            boolean bl2 = bl = 0 != (clazz2.getModifiers() & 0x10);
            if (bl) {
                this.setElementsAreSameType(true);
            }
        }

        @Override
        public void write(Kryo kryo, Output output, Object[] objectArray) {
            if (objectArray == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(objectArray.length + 1, true);
            Class<?> clazz = objectArray.getClass().getComponentType();
            if (this.elementsAreSameType || Modifier.isFinal(clazz.getModifiers())) {
                Serializer serializer = kryo.getSerializer(clazz);
                serializer.setGenerics(kryo, this.generics);
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    if (this.elementsCanBeNull) {
                        kryo.writeObjectOrNull(output, objectArray[i], serializer);
                        continue;
                    }
                    kryo.writeObject(output, objectArray[i], serializer);
                }
            } else {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    if (objectArray[i] != null) {
                        Serializer serializer = kryo.getSerializer(objectArray[i].getClass());
                        serializer.setGenerics(kryo, this.generics);
                    }
                    kryo.writeClassAndObject(output, objectArray[i]);
                }
            }
        }

        @Override
        public Object[] read(Kryo kryo, Input input, Class<Object[]> clazz) {
            int n = input.readVarInt(true);
            if (n == 0) {
                return null;
            }
            Object[] objectArray = (Object[])Array.newInstance(clazz.getComponentType(), n - 1);
            kryo.reference(objectArray);
            Class<?> clazz2 = objectArray.getClass().getComponentType();
            if (this.elementsAreSameType || Modifier.isFinal(clazz2.getModifiers())) {
                Serializer serializer = kryo.getSerializer(clazz2);
                serializer.setGenerics(kryo, this.generics);
                int n2 = objectArray.length;
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = this.elementsCanBeNull ? kryo.readObjectOrNull(input, clazz2, serializer) : kryo.readObject(input, clazz2, serializer);
                }
            } else {
                int n3 = objectArray.length;
                for (int i = 0; i < n3; ++i) {
                    Registration registration = kryo.readClass(input);
                    if (registration != null) {
                        registration.getSerializer().setGenerics(kryo, this.generics);
                        objectArray[i] = kryo.readObject(input, registration.getType(), registration.getSerializer());
                        continue;
                    }
                    objectArray[i] = null;
                }
            }
            return objectArray;
        }

        @Override
        public Object[] copy(Kryo kryo, Object[] objectArray) {
            Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), objectArray.length);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = kryo.copy(objectArray[i]);
            }
            return objectArray2;
        }

        public void setElementsCanBeNull(boolean bl) {
            this.elementsCanBeNull = bl;
        }

        public void setElementsAreSameType(boolean bl) {
            this.elementsAreSameType = bl;
        }

        @Override
        public void setGenerics(Kryo kryo, Class[] classArray) {
            this.generics = classArray;
        }
    }

    public static class StringArraySerializer
    extends Serializer<String[]> {
        public StringArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String[] stringArray) {
            if (stringArray == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(stringArray.length + 1, true);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                output.writeString(stringArray[i]);
            }
        }

        @Override
        public String[] read(Kryo kryo, Input input, Class<String[]> clazz) {
            int n = input.readVarInt(true);
            if (n == 0) {
                return null;
            }
            String[] stringArray = new String[--n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = input.readString();
            }
            return stringArray;
        }

        @Override
        public String[] copy(Kryo kryo, String[] stringArray) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            return stringArray2;
        }
    }

    public static class BooleanArraySerializer
    extends Serializer<boolean[]> {
        public BooleanArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, boolean[] blArray) {
            if (blArray == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(blArray.length + 1, true);
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                output.writeBoolean(blArray[i]);
            }
        }

        @Override
        public boolean[] read(Kryo kryo, Input input, Class<boolean[]> clazz) {
            int n = input.readVarInt(true);
            if (n == 0) {
                return null;
            }
            boolean[] blArray = new boolean[--n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = input.readBoolean();
            }
            return blArray;
        }

        @Override
        public boolean[] copy(Kryo kryo, boolean[] blArray) {
            boolean[] blArray2 = new boolean[blArray.length];
            System.arraycopy(blArray, 0, blArray2, 0, blArray2.length);
            return blArray2;
        }
    }

    public static class DoubleArraySerializer
    extends Serializer<double[]> {
        public DoubleArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, double[] dArray) {
            if (dArray == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(dArray.length + 1, true);
            output.writeDoubles(dArray);
        }

        @Override
        public double[] read(Kryo kryo, Input input, Class<double[]> clazz) {
            int n = input.readVarInt(true);
            if (n == 0) {
                return null;
            }
            return input.readDoubles(n - 1);
        }

        @Override
        public double[] copy(Kryo kryo, double[] dArray) {
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
            return dArray2;
        }
    }

    public static class CharArraySerializer
    extends Serializer<char[]> {
        public CharArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, char[] cArray) {
            if (cArray == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(cArray.length + 1, true);
            output.writeChars(cArray);
        }

        @Override
        public char[] read(Kryo kryo, Input input, Class<char[]> clazz) {
            int n = input.readVarInt(true);
            if (n == 0) {
                return null;
            }
            return input.readChars(n - 1);
        }

        @Override
        public char[] copy(Kryo kryo, char[] cArray) {
            char[] cArray2 = new char[cArray.length];
            System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
            return cArray2;
        }
    }

    public static class ShortArraySerializer
    extends Serializer<short[]> {
        public ShortArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, short[] sArray) {
            if (sArray == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(sArray.length + 1, true);
            output.writeShorts(sArray);
        }

        @Override
        public short[] read(Kryo kryo, Input input, Class<short[]> clazz) {
            int n = input.readVarInt(true);
            if (n == 0) {
                return null;
            }
            return input.readShorts(n - 1);
        }

        @Override
        public short[] copy(Kryo kryo, short[] sArray) {
            short[] sArray2 = new short[sArray.length];
            System.arraycopy(sArray, 0, sArray2, 0, sArray2.length);
            return sArray2;
        }
    }

    public static class LongArraySerializer
    extends Serializer<long[]> {
        public LongArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, long[] lArray) {
            if (lArray == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(lArray.length + 1, true);
            output.writeLongs(lArray, false);
        }

        @Override
        public long[] read(Kryo kryo, Input input, Class<long[]> clazz) {
            int n = input.readVarInt(true);
            if (n == 0) {
                return null;
            }
            return input.readLongs(n - 1, false);
        }

        @Override
        public long[] copy(Kryo kryo, long[] lArray) {
            long[] lArray2 = new long[lArray.length];
            System.arraycopy(lArray, 0, lArray2, 0, lArray2.length);
            return lArray2;
        }
    }

    public static class FloatArraySerializer
    extends Serializer<float[]> {
        public FloatArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, float[] fArray) {
            if (fArray == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(fArray.length + 1, true);
            output.writeFloats(fArray);
        }

        @Override
        public float[] read(Kryo kryo, Input input, Class<float[]> clazz) {
            int n = input.readVarInt(true);
            if (n == 0) {
                return null;
            }
            return input.readFloats(n - 1);
        }

        @Override
        public float[] copy(Kryo kryo, float[] fArray) {
            float[] fArray2 = new float[fArray.length];
            System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
            return fArray2;
        }
    }

    public static class IntArraySerializer
    extends Serializer<int[]> {
        public IntArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, int[] nArray) {
            if (nArray == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(nArray.length + 1, true);
            output.writeInts(nArray, false);
        }

        @Override
        public int[] read(Kryo kryo, Input input, Class<int[]> clazz) {
            int n = input.readVarInt(true);
            if (n == 0) {
                return null;
            }
            return input.readInts(n - 1, false);
        }

        @Override
        public int[] copy(Kryo kryo, int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
            return nArray2;
        }
    }

    public static class ByteArraySerializer
    extends Serializer<byte[]> {
        public ByteArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, byte[] byArray) {
            if (byArray == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(byArray.length + 1, true);
            output.writeBytes(byArray);
        }

        @Override
        public byte[] read(Kryo kryo, Input input, Class<byte[]> clazz) {
            int n = input.readVarInt(true);
            if (n == 0) {
                return null;
            }
            return input.readBytes(n - 1);
        }

        @Override
        public byte[] copy(Kryo kryo, byte[] byArray) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
    }
}

