/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private int[] tags;
    private int writeFieldCount;
    private boolean[] deprecated;

    public TaggedFieldSerializer(Kryo kryo, Class clazz) {
        super(kryo, clazz);
    }

    @Override
    protected void initializeCachedFields() {
        Field field;
        int n;
        FieldSerializer.CachedField[] cachedFieldArray = this.getFields();
        int n2 = cachedFieldArray.length;
        for (n = 0; n < n2; ++n) {
            field = cachedFieldArray[n].getField();
            if (field.getAnnotation(Tag.class) != null) continue;
            super.removeField(field.getName());
        }
        cachedFieldArray = this.getFields();
        this.tags = new int[cachedFieldArray.length];
        this.deprecated = new boolean[cachedFieldArray.length];
        this.writeFieldCount = cachedFieldArray.length;
        n2 = cachedFieldArray.length;
        for (n = 0; n < n2; ++n) {
            field = cachedFieldArray[n].getField();
            this.tags[n] = field.getAnnotation(Tag.class).value();
            if (field.getAnnotation(Deprecated.class) == null) continue;
            this.deprecated[n] = true;
            --this.writeFieldCount;
        }
    }

    @Override
    public void removeField(String string) {
        super.removeField(string);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T t) {
        FieldSerializer.CachedField[] cachedFieldArray = this.getFields();
        output.writeVarInt(this.writeFieldCount, true);
        int n = cachedFieldArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.deprecated[i]) continue;
            output.writeVarInt(this.tags[i], true);
            cachedFieldArray[i].write(output, t);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> clazz) {
        T t = this.create(kryo, input, clazz);
        kryo.reference(t);
        int n = input.readVarInt(true);
        int[] nArray = this.tags;
        FieldSerializer.CachedField[] cachedFieldArray = this.getFields();
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            int n3 = input.readVarInt(true);
            FieldSerializer.CachedField cachedField = null;
            int n4 = nArray.length;
            for (int j = 0; j < n4; ++j) {
                if (nArray[j] != n3) continue;
                cachedField = cachedFieldArray[j];
                break;
            }
            if (cachedField == null) {
                throw new KryoException("Unknown field tag: " + n3 + " (" + this.getType().getName() + ")");
            }
            cachedField.read(input, t);
        }
        return t;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();
    }
}

