/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import org.testng.ISuite;
import org.testng.ITestNGMethod;
import org.testng.collections.Maps;
import org.testng.collections.SetMultiMap;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BaseMultiSuitePanel;
import org.testng.reporters.jq.Model;

public class IgnoredMethodsPanel
extends BaseMultiSuitePanel {
    public IgnoredMethodsPanel(Model model) {
        super(model);
    }

    public String getPrefix() {
        return "ignored-methods-";
    }

    public String getHeader(ISuite suite) {
        return IgnoredMethodsPanel.pluralize(suite.getExcludedMethods().size(), "ignored method");
    }

    public String getContent(ISuite suite, XMLStringBuffer main) {
        XMLStringBuffer xsb = new XMLStringBuffer(main.getCurrentIndent());
        SetMultiMap<Class, ITestNGMethod> map = Maps.newSetMultiMap();
        for (ITestNGMethod method : suite.getExcludedMethods()) {
            map.put(method.getTestClass().getRealClass(), method);
        }
        for (Class c : map.getKeys()) {
            xsb.push("div", "class", "ignored-class-div");
            xsb.addRequired("span", c.getName(), "class", "ignored-class-name");
            xsb.push("div", "class", "ignored-methods-div");
            for (ITestNGMethod m : map.get(c)) {
                xsb.addRequired("span", m.getMethodName(), "class", "ignored-method-name");
                xsb.addEmptyElement("br");
            }
            xsb.pop("div");
            xsb.pop("div");
        }
        return xsb.toXML();
    }

    public String getNavigatorLink(ISuite suite) {
        return "Ignored methods";
    }
}

