/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.tasks;

import com.intellij.tasks.impl.SimpleComment;
import com.intellij.util.text.DateFormatUtil;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubComment
extends SimpleComment {
    @Nullable
    private final String myAvatarUrl;
    @NotNull
    private final String myUserHtmlUrl;

    public GithubComment(@Nullable Date date, @Nullable String author, @NotNull String text, @Nullable String avatarUrl, @NotNull String userHtmlUrl) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/github/tasks/GithubComment", "<init>"));
        }
        if (userHtmlUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userHtmlUrl", "org/jetbrains/plugins/github/tasks/GithubComment", "<init>"));
        }
        super(date, author, text);
        this.myAvatarUrl = avatarUrl;
        this.myUserHtmlUrl = userHtmlUrl;
    }

    public void appendTo(StringBuilder builder) {
        builder.append("<hr>");
        builder.append("<table>");
        builder.append("<tr><td>");
        if (this.myAvatarUrl != null) {
            builder.append("<img src=\"").append(this.myAvatarUrl).append("\" height=\"40\" width=\"40\"/><br>");
        }
        builder.append("</td><td>");
        if (this.getAuthor() != null) {
            builder.append("<b>Author:</b> <a href=\"").append(this.myUserHtmlUrl).append("\">").append(this.getAuthor()).append("</a><br>");
        }
        if (this.getDate() != null) {
            builder.append("<b>Date:</b> ").append(DateFormatUtil.formatDateTime((Date)this.getDate())).append("<br>");
        }
        builder.append("</td></tr></table>");
        builder.append(this.getText()).append("<br>");
    }
}

